/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.metrics;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.query.QueryShardContext;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.DocValueFormat;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.Aggregator;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.AggregatorFactories;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.AggregatorFactory;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.metrics.WeightedAvgAggregator;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.support.MultiValuesSource;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.support.MultiValuesSourceAggregatorFactory;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.support.ValuesSource;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.internal.SearchContext;

class WeightedAvgAggregatorFactory
extends MultiValuesSourceAggregatorFactory<ValuesSource.Numeric> {
    WeightedAvgAggregatorFactory(String name, Map<String, ValuesSourceConfig<ValuesSource.Numeric>> configs, DocValueFormat format, QueryShardContext queryShardContext, AggregatorFactory parent, AggregatorFactories.Builder subFactoriesBuilder, Map<String, Object> metaData) throws IOException {
        super(name, configs, format, queryShardContext, parent, subFactoriesBuilder, metaData);
    }

    @Override
    protected Aggregator createUnmapped(SearchContext searchContext, Aggregator parent, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) throws IOException {
        return new WeightedAvgAggregator(this.name, null, this.format, searchContext, parent, pipelineAggregators, metaData);
    }

    @Override
    protected Aggregator doCreateInternal(SearchContext searchContext, Map<String, ValuesSourceConfig<ValuesSource.Numeric>> configs, DocValueFormat format, Aggregator parent, boolean collectsFromSingleBucket, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) throws IOException {
        MultiValuesSource.NumericMultiValuesSource numericMultiVS = new MultiValuesSource.NumericMultiValuesSource(configs, this.queryShardContext);
        if (numericMultiVS.areValuesSourcesEmpty()) {
            return this.createUnmapped(searchContext, parent, pipelineAggregators, metaData);
        }
        return new WeightedAvgAggregator(this.name, numericMultiVS, format, searchContext, parent, pipelineAggregators, metaData);
    }
}

