/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.bucket.histogram;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.LeafReaderContext;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.BytesRef;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.CollectionUtil;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.Nullable;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.lease.Releasables;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.util.LongHash;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.fielddata.SortedBinaryDocValues;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper.RangeFieldMapper;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper.RangeType;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.DocValueFormat;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.Aggregator;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.AggregatorFactories;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.BucketOrder;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.InternalAggregation;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.InternalOrder;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.LeafBucketCollector;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.LeafBucketCollectorBase;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.bucket.BucketsAggregator;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.bucket.histogram.InternalHistogram;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.support.ValuesSource;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.internal.SearchContext;

public class RangeHistogramAggregator
extends BucketsAggregator {
    private final ValuesSource.Range valuesSource;
    private final DocValueFormat formatter;
    private final double interval;
    private final double offset;
    private final BucketOrder order;
    private final boolean keyed;
    private final long minDocCount;
    private final double minBound;
    private final double maxBound;
    private final LongHash bucketOrds;

    RangeHistogramAggregator(String name, AggregatorFactories factories, double interval, double offset, BucketOrder order, boolean keyed, long minDocCount, double minBound, double maxBound, @Nullable ValuesSource.Range valuesSource, DocValueFormat formatter, SearchContext context, Aggregator parent, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) throws IOException {
        super(name, factories, context, parent, pipelineAggregators, metaData);
        if (interval <= 0.0) {
            throw new IllegalArgumentException("interval must be positive, got: " + interval);
        }
        this.interval = interval;
        this.offset = offset;
        this.order = InternalOrder.validate(order, this);
        this.keyed = keyed;
        this.minDocCount = minDocCount;
        this.minBound = minBound;
        this.maxBound = maxBound;
        this.valuesSource = valuesSource;
        this.formatter = formatter;
        this.bucketOrds = new LongHash(1L, context.bigArrays());
    }

    @Override
    protected LeafBucketCollector getLeafCollector(LeafReaderContext ctx, final LeafBucketCollector sub) throws IOException {
        if (this.valuesSource == null) {
            return LeafBucketCollector.NO_OP_COLLECTOR;
        }
        final SortedBinaryDocValues values = this.valuesSource.bytesValues(ctx);
        final RangeType rangeType = this.valuesSource.rangeType();
        return new LeafBucketCollectorBase(sub, values){

            @Override
            public void collect(int doc, long bucket) throws IOException {
                assert (bucket == 0L);
                if (values.advanceExact(doc)) {
                    int valuesCount = values.docValueCount();
                    assert (valuesCount == 1) : "Value count for ranges should always be 1";
                    double previousKey = Double.NEGATIVE_INFINITY;
                    for (int i = 0; i < valuesCount; ++i) {
                        BytesRef encodedRanges = values.nextValue();
                        List<RangeFieldMapper.Range> ranges = rangeType.decodeRanges(encodedRanges);
                        double previousFrom = Double.NEGATIVE_INFINITY;
                        for (RangeFieldMapper.Range range : ranges) {
                            double key;
                            Double from = rangeType.doubleValue(range.getFrom());
                            assert (from >= previousFrom) : "Start of range not >= previous start";
                            Double to = rangeType.doubleValue(range.getTo());
                            double startKey = Math.floor((from - RangeHistogramAggregator.this.offset) / RangeHistogramAggregator.this.interval);
                            double endKey = Math.floor((to - RangeHistogramAggregator.this.offset) / RangeHistogramAggregator.this.interval);
                            double d = key = startKey > previousKey ? startKey : previousKey;
                            while (key <= endKey) {
                                if (key != previousKey) {
                                    long bucketOrd = RangeHistogramAggregator.this.bucketOrds.add(Double.doubleToLongBits(key));
                                    if (bucketOrd < 0L) {
                                        bucketOrd = -1L - bucketOrd;
                                        RangeHistogramAggregator.this.collectExistingBucket(sub, doc, bucketOrd);
                                    } else {
                                        RangeHistogramAggregator.this.collectBucket(sub, doc, bucketOrd);
                                    }
                                }
                                key += 1.0;
                            }
                            if (!(endKey > previousKey)) continue;
                            previousKey = endKey;
                        }
                    }
                }
            }
        };
    }

    @Override
    public InternalAggregation buildAggregation(long bucket) throws IOException {
        assert (bucket == 0L);
        this.consumeBucketsAndMaybeBreak((int)this.bucketOrds.size());
        ArrayList<InternalHistogram.Bucket> buckets = new ArrayList<InternalHistogram.Bucket>((int)this.bucketOrds.size());
        for (long i = 0L; i < this.bucketOrds.size(); ++i) {
            double roundKey = Double.longBitsToDouble(this.bucketOrds.get(i));
            double key = roundKey * this.interval + this.offset;
            buckets.add(new InternalHistogram.Bucket(key, this.bucketDocCount(i), this.keyed, this.formatter, this.bucketAggregations(i)));
        }
        CollectionUtil.introSort(buckets, BucketOrder.key(true).comparator(this));
        InternalHistogram.EmptyBucketInfo emptyBucketInfo = null;
        if (this.minDocCount == 0L) {
            emptyBucketInfo = new InternalHistogram.EmptyBucketInfo(this.interval, this.offset, this.minBound, this.maxBound, this.buildEmptySubAggregations());
        }
        return new InternalHistogram(this.name, buckets, this.order, this.minDocCount, emptyBucketInfo, this.formatter, this.keyed, this.pipelineAggregators(), this.metaData());
    }

    @Override
    public InternalAggregation buildEmptyAggregation() {
        InternalHistogram.EmptyBucketInfo emptyBucketInfo = null;
        if (this.minDocCount == 0L) {
            emptyBucketInfo = new InternalHistogram.EmptyBucketInfo(this.interval, this.offset, this.minBound, this.maxBound, this.buildEmptySubAggregations());
        }
        return new InternalHistogram(this.name, Collections.emptyList(), this.order, this.minDocCount, emptyBucketInfo, this.formatter, this.keyed, this.pipelineAggregators(), this.metaData());
    }

    @Override
    public void doClose() {
        Releasables.close(this.bucketOrds);
    }
}

