/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.rest.action.cat;

import java.util.List;
import org.apache.flink.elasticsearch7.shaded.com.carrotsearch.hppc.cursors.ObjectObjectCursor;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.ActionListener;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.admin.indices.alias.get.GetAliasesRequest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.admin.indices.alias.get.GetAliasesResponse;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.node.NodeClient;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.metadata.AliasMetaData;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.Strings;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.Table;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.rest.BaseRestHandler;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.rest.RestController;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.rest.RestRequest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.rest.RestResponse;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.rest.action.RestResponseListener;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.rest.action.cat.AbstractCatAction;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.rest.action.cat.RestTable;

public class RestAliasAction
extends AbstractCatAction {
    public RestAliasAction(RestController controller) {
        controller.registerHandler(RestRequest.Method.GET, "/_cat/aliases", this);
        controller.registerHandler(RestRequest.Method.GET, "/_cat/aliases/{alias}", this);
    }

    @Override
    public String getName() {
        return "cat_alias_action";
    }

    @Override
    protected BaseRestHandler.RestChannelConsumer doCatRequest(final RestRequest request, NodeClient client) {
        GetAliasesRequest getAliasesRequest = request.hasParam("alias") ? new GetAliasesRequest(Strings.commaDelimitedListToStringArray(request.param("alias"))) : new GetAliasesRequest();
        getAliasesRequest.local(request.paramAsBoolean("local", getAliasesRequest.local()));
        return channel -> client.admin().indices().getAliases(getAliasesRequest, (ActionListener<GetAliasesResponse>)new RestResponseListener<GetAliasesResponse>(channel){

            @Override
            public RestResponse buildResponse(GetAliasesResponse response) throws Exception {
                Table tab = RestAliasAction.this.buildTable(request, response);
                return RestTable.buildResponse(tab, this.channel);
            }
        });
    }

    @Override
    protected void documentation(StringBuilder sb) {
        sb.append("/_cat/aliases\n");
        sb.append("/_cat/aliases/{alias}\n");
    }

    @Override
    protected Table getTableWithHeader(RestRequest request) {
        Table table = new Table();
        table.startHeaders();
        table.addCell("alias", "alias:a;desc:alias name");
        table.addCell("index", "alias:i,idx;desc:index alias points to");
        table.addCell("filter", "alias:f,fi;desc:filter");
        table.addCell("routing.index", "alias:ri,routingIndex;desc:index routing");
        table.addCell("routing.search", "alias:rs,routingSearch;desc:search routing");
        table.addCell("is_write_index", "alias:w,isWriteIndex;desc:write index");
        table.endHeaders();
        return table;
    }

    private Table buildTable(RestRequest request, GetAliasesResponse response) {
        Table table = this.getTableWithHeader(request);
        for (ObjectObjectCursor<String, List<AliasMetaData>> objectObjectCursor : response.getAliases()) {
            String indexName = (String)objectObjectCursor.key;
            for (AliasMetaData aliasMetaData : (List)objectObjectCursor.value) {
                table.startRow();
                table.addCell(aliasMetaData.alias());
                table.addCell(indexName);
                table.addCell(aliasMetaData.filteringRequired() ? "*" : "-");
                String indexRouting = Strings.hasLength(aliasMetaData.indexRouting()) ? aliasMetaData.indexRouting() : "-";
                table.addCell(indexRouting);
                String searchRouting = Strings.hasLength(aliasMetaData.searchRouting()) ? aliasMetaData.searchRouting() : "-";
                table.addCell(searchRouting);
                String isWriteIndex = aliasMetaData.writeIndex() == null ? "-" : aliasMetaData.writeIndex().toString();
                table.addCell(isWriteIndex);
                table.endRow();
            }
        }
        return table;
    }
}

