/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.ingest;

import java.util.Map;
import java.util.function.BiConsumer;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.ingest.AbstractProcessor;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.ingest.ConfigurationUtils;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.ingest.IngestDocument;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.ingest.IngestService;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.ingest.Pipeline;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.ingest.Processor;

public class PipelineProcessor
extends AbstractProcessor {
    public static final String TYPE = "pipeline";
    private final String pipelineName;
    private final IngestService ingestService;

    private PipelineProcessor(String tag, String pipelineName, IngestService ingestService) {
        super(tag);
        this.pipelineName = pipelineName;
        this.ingestService = ingestService;
    }

    @Override
    public void execute(IngestDocument ingestDocument, BiConsumer<IngestDocument, Exception> handler) {
        Pipeline pipeline = this.ingestService.getPipeline(this.pipelineName);
        if (pipeline != null) {
            ingestDocument.executePipeline(pipeline, handler);
        } else {
            handler.accept(null, new IllegalStateException("Pipeline processor configured for non-existent pipeline [" + this.pipelineName + ']'));
        }
    }

    @Override
    public IngestDocument execute(IngestDocument ingestDocument) throws Exception {
        throw new UnsupportedOperationException("this method should not get executed");
    }

    Pipeline getPipeline() {
        return this.ingestService.getPipeline(this.pipelineName);
    }

    @Override
    public String getType() {
        return TYPE;
    }

    String getPipelineName() {
        return this.pipelineName;
    }

    public static final class Factory
    implements Processor.Factory {
        private final IngestService ingestService;

        public Factory(IngestService ingestService) {
            this.ingestService = ingestService;
        }

        @Override
        public PipelineProcessor create(Map<String, Processor.Factory> registry, String processorTag, Map<String, Object> config) throws Exception {
            String pipeline = ConfigurationUtils.readStringProperty(PipelineProcessor.TYPE, processorTag, config, "name");
            return new PipelineProcessor(processorTag, pipeline, this.ingestService);
        }
    }
}

