/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.ingest;

import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.metrics.CounterMetric;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.metrics.MeanMetric;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.ingest.IngestStats;

class IngestMetric {
    private final MeanMetric ingestTime = new MeanMetric();
    private final CounterMetric ingestCurrent = new CounterMetric();
    private final CounterMetric ingestCount = new CounterMetric();
    private final CounterMetric ingestFailed = new CounterMetric();

    IngestMetric() {
    }

    void preIngest() {
        this.ingestCurrent.inc();
    }

    void postIngest(long ingestTimeInMillis) {
        this.ingestCurrent.dec();
        this.ingestTime.inc(ingestTimeInMillis);
        this.ingestCount.inc();
    }

    void ingestFailed() {
        this.ingestFailed.inc();
    }

    void add(IngestMetric metrics) {
        this.ingestCount.inc(metrics.ingestCount.count());
        this.ingestTime.inc(metrics.ingestTime.sum());
        this.ingestFailed.inc(metrics.ingestFailed.count());
    }

    IngestStats.Stats createStats() {
        return new IngestStats.Stats(this.ingestCount.count(), this.ingestTime.sum(), this.ingestCurrent.count(), this.ingestFailed.count());
    }
}

