/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.indices.recovery;

import java.io.IOException;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.Version;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.io.stream.StreamInput;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.io.stream.StreamOutput;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.shard.ShardId;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.transport.TransportRequest;

class RecoveryPrepareForTranslogOperationsRequest
extends TransportRequest {
    private final long recoveryId;
    private final ShardId shardId;
    private final int totalTranslogOps;

    RecoveryPrepareForTranslogOperationsRequest(long recoveryId, ShardId shardId, int totalTranslogOps) {
        this.recoveryId = recoveryId;
        this.shardId = shardId;
        this.totalTranslogOps = totalTranslogOps;
    }

    RecoveryPrepareForTranslogOperationsRequest(StreamInput in) throws IOException {
        super(in);
        this.recoveryId = in.readLong();
        this.shardId = new ShardId(in);
        this.totalTranslogOps = in.readVInt();
        if (in.getVersion().before(Version.V_6_0_0_alpha1)) {
            in.readLong();
        }
        if (in.getVersion().onOrAfter(Version.V_6_2_0) && in.getVersion().before(Version.V_7_4_0)) {
            in.readBoolean();
        }
    }

    public long recoveryId() {
        return this.recoveryId;
    }

    public ShardId shardId() {
        return this.shardId;
    }

    public int totalTranslogOps() {
        return this.totalTranslogOps;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeLong(this.recoveryId);
        this.shardId.writeTo(out);
        out.writeVInt(this.totalTranslogOps);
        if (out.getVersion().before(Version.V_6_0_0_alpha1)) {
            out.writeLong(-1L);
        }
        if (out.getVersion().onOrAfter(Version.V_6_2_0) && out.getVersion().before(Version.V_7_4_0)) {
            out.writeBoolean(true);
        }
    }
}

