/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.shard;

import java.util.List;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.ExceptionsHelper;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.internal.SearchContext;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.transport.TransportRequest;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;

public interface SearchOperationListener {
    default public void onPreQueryPhase(SearchContext searchContext) {
    }

    default public void onFailedQueryPhase(SearchContext searchContext) {
    }

    default public void onQueryPhase(SearchContext searchContext, long tookInNanos) {
    }

    default public void onPreFetchPhase(SearchContext searchContext) {
    }

    default public void onFailedFetchPhase(SearchContext searchContext) {
    }

    default public void onFetchPhase(SearchContext searchContext, long tookInNanos) {
    }

    default public void onNewContext(SearchContext context) {
    }

    default public void onFreeContext(SearchContext context) {
    }

    default public void onNewScrollContext(SearchContext context) {
    }

    default public void onFreeScrollContext(SearchContext context) {
    }

    default public void validateSearchContext(SearchContext context, TransportRequest transportRequest) {
    }

    public static final class CompositeListener
    implements SearchOperationListener {
        private final List<SearchOperationListener> listeners;
        private final Logger logger;

        CompositeListener(List<SearchOperationListener> listeners, Logger logger) {
            this.listeners = listeners;
            this.logger = logger;
        }

        @Override
        public void onPreQueryPhase(SearchContext searchContext) {
            for (SearchOperationListener listener : this.listeners) {
                try {
                    listener.onPreQueryPhase(searchContext);
                }
                catch (Exception e) {
                    this.logger.warn(() -> new ParameterizedMessage("onPreQueryPhase listener [{}] failed", (Object)listener), (Throwable)e);
                }
            }
        }

        @Override
        public void onFailedQueryPhase(SearchContext searchContext) {
            for (SearchOperationListener listener : this.listeners) {
                try {
                    listener.onFailedQueryPhase(searchContext);
                }
                catch (Exception e) {
                    this.logger.warn(() -> new ParameterizedMessage("onFailedQueryPhase listener [{}] failed", (Object)listener), (Throwable)e);
                }
            }
        }

        @Override
        public void onQueryPhase(SearchContext searchContext, long tookInNanos) {
            for (SearchOperationListener listener : this.listeners) {
                try {
                    listener.onQueryPhase(searchContext, tookInNanos);
                }
                catch (Exception e) {
                    this.logger.warn(() -> new ParameterizedMessage("onQueryPhase listener [{}] failed", (Object)listener), (Throwable)e);
                }
            }
        }

        @Override
        public void onPreFetchPhase(SearchContext searchContext) {
            for (SearchOperationListener listener : this.listeners) {
                try {
                    listener.onPreFetchPhase(searchContext);
                }
                catch (Exception e) {
                    this.logger.warn(() -> new ParameterizedMessage("onPreFetchPhase listener [{}] failed", (Object)listener), (Throwable)e);
                }
            }
        }

        @Override
        public void onFailedFetchPhase(SearchContext searchContext) {
            for (SearchOperationListener listener : this.listeners) {
                try {
                    listener.onFailedFetchPhase(searchContext);
                }
                catch (Exception e) {
                    this.logger.warn(() -> new ParameterizedMessage("onFailedFetchPhase listener [{}] failed", (Object)listener), (Throwable)e);
                }
            }
        }

        @Override
        public void onFetchPhase(SearchContext searchContext, long tookInNanos) {
            for (SearchOperationListener listener : this.listeners) {
                try {
                    listener.onFetchPhase(searchContext, tookInNanos);
                }
                catch (Exception e) {
                    this.logger.warn(() -> new ParameterizedMessage("onFetchPhase listener [{}] failed", (Object)listener), (Throwable)e);
                }
            }
        }

        @Override
        public void onNewContext(SearchContext context) {
            for (SearchOperationListener listener : this.listeners) {
                try {
                    listener.onNewContext(context);
                }
                catch (Exception e) {
                    this.logger.warn(() -> new ParameterizedMessage("onNewContext listener [{}] failed", (Object)listener), (Throwable)e);
                }
            }
        }

        @Override
        public void onFreeContext(SearchContext context) {
            for (SearchOperationListener listener : this.listeners) {
                try {
                    listener.onFreeContext(context);
                }
                catch (Exception e) {
                    this.logger.warn(() -> new ParameterizedMessage("onFreeContext listener [{}] failed", (Object)listener), (Throwable)e);
                }
            }
        }

        @Override
        public void onNewScrollContext(SearchContext context) {
            for (SearchOperationListener listener : this.listeners) {
                try {
                    listener.onNewScrollContext(context);
                }
                catch (Exception e) {
                    this.logger.warn(() -> new ParameterizedMessage("onNewScrollContext listener [{}] failed", (Object)listener), (Throwable)e);
                }
            }
        }

        @Override
        public void onFreeScrollContext(SearchContext context) {
            for (SearchOperationListener listener : this.listeners) {
                try {
                    listener.onFreeScrollContext(context);
                }
                catch (Exception e) {
                    this.logger.warn(() -> new ParameterizedMessage("onFreeScrollContext listener [{}] failed", (Object)listener), (Throwable)e);
                }
            }
        }

        @Override
        public void validateSearchContext(SearchContext context, TransportRequest request) {
            Exception exception = null;
            for (SearchOperationListener listener : this.listeners) {
                try {
                    listener.validateSearchContext(context, request);
                }
                catch (Exception e) {
                    exception = ExceptionsHelper.useOrSuppress(exception, e);
                }
            }
            ExceptionsHelper.reThrowIfNotNull(exception);
        }
    }
}

