/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.search.stats;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.collect.MapBuilder;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.metrics.CounterMetric;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.metrics.MeanMetric;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.regex.Regex;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.search.stats.SearchStats;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.shard.SearchOperationListener;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.internal.SearchContext;

public final class ShardSearchStats
implements SearchOperationListener {
    private final StatsHolder totalStats = new StatsHolder();
    private final CounterMetric openContexts = new CounterMetric();
    private volatile Map<String, StatsHolder> groupsStats = Collections.emptyMap();

    public SearchStats stats(String ... groups) {
        HashMap<String, SearchStats.Stats> groupsSt;
        SearchStats.Stats total;
        block4: {
            total = this.totalStats.stats();
            groupsSt = null;
            if (groups == null || groups.length <= 0) break block4;
            groupsSt = new HashMap<String, SearchStats.Stats>(this.groupsStats.size());
            if (groups.length == 1 && groups[0].equals("_all")) {
                for (Map.Entry<String, StatsHolder> entry : this.groupsStats.entrySet()) {
                    groupsSt.put(entry.getKey(), entry.getValue().stats());
                }
            } else {
                for (Map.Entry<String, StatsHolder> entry : this.groupsStats.entrySet()) {
                    if (!Regex.simpleMatch(groups, entry.getKey())) continue;
                    groupsSt.put(entry.getKey(), entry.getValue().stats());
                }
            }
        }
        return new SearchStats(total, this.openContexts.count(), groupsSt);
    }

    @Override
    public void onPreQueryPhase(SearchContext searchContext) {
        this.computeStats(searchContext, statsHolder -> {
            if (searchContext.hasOnlySuggest()) {
                statsHolder.suggestCurrent.inc();
            } else {
                statsHolder.queryCurrent.inc();
            }
        });
    }

    @Override
    public void onFailedQueryPhase(SearchContext searchContext) {
        this.computeStats(searchContext, statsHolder -> {
            if (searchContext.hasOnlySuggest()) {
                statsHolder.suggestCurrent.dec();
                assert (statsHolder.suggestCurrent.count() >= 0L);
            } else {
                statsHolder.queryCurrent.dec();
                assert (statsHolder.queryCurrent.count() >= 0L);
            }
        });
    }

    @Override
    public void onQueryPhase(SearchContext searchContext, long tookInNanos) {
        this.computeStats(searchContext, statsHolder -> {
            if (searchContext.hasOnlySuggest()) {
                statsHolder.suggestMetric.inc(tookInNanos);
                statsHolder.suggestCurrent.dec();
                assert (statsHolder.suggestCurrent.count() >= 0L);
            } else {
                statsHolder.queryMetric.inc(tookInNanos);
                statsHolder.queryCurrent.dec();
                assert (statsHolder.queryCurrent.count() >= 0L);
            }
        });
    }

    @Override
    public void onPreFetchPhase(SearchContext searchContext) {
        this.computeStats(searchContext, statsHolder -> statsHolder.fetchCurrent.inc());
    }

    @Override
    public void onFailedFetchPhase(SearchContext searchContext) {
        this.computeStats(searchContext, statsHolder -> statsHolder.fetchCurrent.dec());
    }

    @Override
    public void onFetchPhase(SearchContext searchContext, long tookInNanos) {
        this.computeStats(searchContext, statsHolder -> {
            statsHolder.fetchMetric.inc(tookInNanos);
            statsHolder.fetchCurrent.dec();
            assert (statsHolder.fetchCurrent.count() >= 0L);
        });
    }

    private void computeStats(SearchContext searchContext, Consumer<StatsHolder> consumer) {
        consumer.accept(this.totalStats);
        if (searchContext.groupStats() != null) {
            for (String group : searchContext.groupStats()) {
                consumer.accept(this.groupStats(group));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StatsHolder groupStats(String group) {
        StatsHolder stats = this.groupsStats.get(group);
        if (stats == null) {
            ShardSearchStats shardSearchStats = this;
            synchronized (shardSearchStats) {
                stats = this.groupsStats.get(group);
                if (stats == null) {
                    stats = new StatsHolder();
                    this.groupsStats = MapBuilder.newMapBuilder(this.groupsStats).put(group, stats).immutableMap();
                }
            }
        }
        return stats;
    }

    @Override
    public void onNewContext(SearchContext context) {
        this.openContexts.inc();
    }

    @Override
    public void onFreeContext(SearchContext context) {
        this.openContexts.dec();
    }

    @Override
    public void onNewScrollContext(SearchContext context) {
        this.totalStats.scrollCurrent.inc();
    }

    @Override
    public void onFreeScrollContext(SearchContext context) {
        this.totalStats.scrollCurrent.dec();
        assert (this.totalStats.scrollCurrent.count() >= 0L);
        this.totalStats.scrollMetric.inc(TimeUnit.NANOSECONDS.toMicros(System.nanoTime() - context.getOriginNanoTime()));
    }

    static final class StatsHolder {
        final MeanMetric queryMetric = new MeanMetric();
        final MeanMetric fetchMetric = new MeanMetric();
        final MeanMetric scrollMetric = new MeanMetric();
        final MeanMetric suggestMetric = new MeanMetric();
        final CounterMetric queryCurrent = new CounterMetric();
        final CounterMetric fetchCurrent = new CounterMetric();
        final CounterMetric scrollCurrent = new CounterMetric();
        final CounterMetric suggestCurrent = new CounterMetric();

        StatsHolder() {
        }

        SearchStats.Stats stats() {
            return new SearchStats.Stats(this.queryMetric.count(), TimeUnit.NANOSECONDS.toMillis(this.queryMetric.sum()), this.queryCurrent.count(), this.fetchMetric.count(), TimeUnit.NANOSECONDS.toMillis(this.fetchMetric.sum()), this.fetchCurrent.count(), this.scrollMetric.count(), TimeUnit.MICROSECONDS.toMillis(this.scrollMetric.sum()), this.scrollCurrent.count(), this.suggestMetric.count(), TimeUnit.NANOSECONDS.toMillis(this.suggestMetric.sum()), this.suggestCurrent.count());
        }
    }
}

