/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.query;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.Query;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.ParseField;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.ParsingException;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.Strings;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.io.stream.StreamInput;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.io.stream.StreamOutput;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.logging.DeprecationLogger;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.lucene.search.Queries;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ObjectParser;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ToXContent;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentBuilder;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentParser;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper.DocumentMapper;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper.MappedFieldType;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.query.AbstractQueryBuilder;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.query.QueryShardContext;
import org.apache.logging.log4j.LogManager;

public class IdsQueryBuilder
extends AbstractQueryBuilder<IdsQueryBuilder> {
    public static final String NAME = "ids";
    private static final DeprecationLogger deprecationLogger = new DeprecationLogger(LogManager.getLogger(IdsQueryBuilder.class));
    static final String TYPES_DEPRECATION_MESSAGE = "[types removal] Types are deprecated in [ids] queries.";
    private static final ParseField TYPE_FIELD = new ParseField("type", new String[0]);
    private static final ParseField VALUES_FIELD = new ParseField("values", new String[0]);
    private final Set<String> ids = new HashSet<String>();
    private String[] types = Strings.EMPTY_ARRAY;
    private static ObjectParser<IdsQueryBuilder, Void> PARSER = new ObjectParser("ids", () -> new IdsQueryBuilder());

    public IdsQueryBuilder() {
    }

    public IdsQueryBuilder(StreamInput in) throws IOException {
        super(in);
        this.types = in.readStringArray();
        Collections.addAll(this.ids, in.readStringArray());
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeStringArray(this.types);
        out.writeStringArray(this.ids.toArray(new String[this.ids.size()]));
    }

    @Deprecated
    public IdsQueryBuilder types(String ... types) {
        if (types == null) {
            throw new IllegalArgumentException("[ids] types cannot be null");
        }
        this.types = types;
        return this;
    }

    @Deprecated
    public String[] types() {
        return this.types;
    }

    public IdsQueryBuilder addIds(String ... ids) {
        if (ids == null) {
            throw new IllegalArgumentException("[ids] ids cannot be null");
        }
        Collections.addAll(this.ids, ids);
        return this;
    }

    public Set<String> ids() {
        return this.ids;
    }

    @Override
    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(NAME);
        if (this.types.length > 0) {
            builder.array(TYPE_FIELD.getPreferredName(), this.types);
        }
        builder.startArray(VALUES_FIELD.getPreferredName());
        for (String value : this.ids) {
            builder.value(value);
        }
        builder.endArray();
        this.printBoostAndQueryName(builder);
        builder.endObject();
    }

    public static IdsQueryBuilder fromXContent(XContentParser parser) {
        try {
            IdsQueryBuilder builder = PARSER.apply(parser, null);
            if (builder.types().length > 0) {
                deprecationLogger.deprecatedAndMaybeLog("ids_query_with_types", TYPES_DEPRECATION_MESSAGE, new Object[0]);
            }
            return builder;
        }
        catch (IllegalArgumentException e) {
            throw new ParsingException(parser.getTokenLocation(), e.getMessage(), e, new Object[0]);
        }
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }

    @Override
    protected Query doToQuery(QueryShardContext context) throws IOException {
        DocumentMapper mapper;
        MappedFieldType idField = context.fieldMapper("_id");
        if (idField == null) {
            return new MatchNoDocsQuery("No mappings");
        }
        if (this.ids.isEmpty()) {
            return Queries.newMatchNoDocsQuery("Missing ids in \"" + this.getName() + "\" query.");
        }
        Collection<String> typesForQuery = this.types.length == 0 ? context.queryTypes() : (this.types.length == 1 && "_all".equals(this.types[0]) ? Collections.singleton(mapper.type()) : new HashSet<String>(Arrays.asList(this.types)));
        if (typesForQuery.contains((mapper = context.getMapperService().documentMapper()).type())) {
            return idField.termsQuery(new ArrayList<String>(this.ids), context);
        }
        return new MatchNoDocsQuery("Type mismatch");
    }

    @Override
    protected int doHashCode() {
        return Objects.hash(this.ids, Arrays.hashCode(this.types));
    }

    @Override
    protected boolean doEquals(IdsQueryBuilder other) {
        return Objects.equals(this.ids, other.ids) && Arrays.equals(this.types, other.types);
    }

    static {
        PARSER.declareStringArray(ObjectParser.fromList(String.class, IdsQueryBuilder::types), TYPE_FIELD);
        PARSER.declareStringArray(ObjectParser.fromList(String.class, IdsQueryBuilder::addIds), VALUES_FIELD);
        IdsQueryBuilder.declareStandardFields(PARSER);
    }
}

