/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.fielddata.plain;

import java.io.IOException;
import java.util.function.Function;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.DirectoryReader;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.LeafReaderContext;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.OrdinalMap;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.SortedSetDocValues;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.SortField;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.SortedSetSelector;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.SortedSetSortField;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.ElasticsearchException;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.Nullable;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.IndexSettings;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.fielddata.AtomicOrdinalsFieldData;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.fielddata.IndexFieldData;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.fielddata.IndexFieldDataCache;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.fielddata.IndexOrdinalsFieldData;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.fielddata.ScriptDocValues;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.fielddata.fieldcomparator.BytesRefFieldComparatorSource;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.fielddata.ordinals.GlobalOrdinalsBuilder;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.fielddata.ordinals.GlobalOrdinalsIndexFieldData;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.fielddata.plain.DocValuesIndexFieldData;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.fielddata.plain.SortedSetDVBytesAtomicFieldData;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.MultiValueMode;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SortedSetDVOrdinalsIndexFieldData
extends DocValuesIndexFieldData
implements IndexOrdinalsFieldData {
    private final IndexSettings indexSettings;
    private final IndexFieldDataCache cache;
    private final CircuitBreakerService breakerService;
    private final Function<SortedSetDocValues, ScriptDocValues<?>> scriptFunction;
    private static final Logger logger = LogManager.getLogger(SortedSetDVOrdinalsIndexFieldData.class);

    public SortedSetDVOrdinalsIndexFieldData(IndexSettings indexSettings, IndexFieldDataCache cache, String fieldName, CircuitBreakerService breakerService, Function<SortedSetDocValues, ScriptDocValues<?>> scriptFunction) {
        super(indexSettings.getIndex(), fieldName);
        this.indexSettings = indexSettings;
        this.cache = cache;
        this.breakerService = breakerService;
        this.scriptFunction = scriptFunction;
    }

    @Override
    public SortField sortField(@Nullable Object missingValue, MultiValueMode sortMode, IndexFieldData.XFieldComparatorSource.Nested nested, boolean reverse) {
        BytesRefFieldComparatorSource source = new BytesRefFieldComparatorSource(this, missingValue, sortMode, nested);
        if (nested != null || sortMode != MultiValueMode.MAX && sortMode != MultiValueMode.MIN || !source.sortMissingLast(missingValue) && !source.sortMissingFirst(missingValue)) {
            return new SortField(this.getFieldName(), source, reverse);
        }
        SortedSetSortField sortField = new SortedSetSortField(this.fieldName, reverse, sortMode == MultiValueMode.MAX ? SortedSetSelector.Type.MAX : SortedSetSelector.Type.MIN);
        ((SortField)sortField).setMissingValue(source.sortMissingLast(missingValue) ^ reverse ? SortedSetSortField.STRING_LAST : SortedSetSortField.STRING_FIRST);
        return sortField;
    }

    @Override
    public AtomicOrdinalsFieldData load(LeafReaderContext context) {
        return new SortedSetDVBytesAtomicFieldData(context.reader(), this.fieldName, this.scriptFunction);
    }

    @Override
    public AtomicOrdinalsFieldData loadDirect(LeafReaderContext context) throws Exception {
        return this.load(context);
    }

    @Override
    public IndexOrdinalsFieldData loadGlobal(DirectoryReader indexReader) {
        IndexOrdinalsFieldData fieldData = this.loadGlobalInternal(indexReader);
        if (fieldData instanceof GlobalOrdinalsIndexFieldData) {
            return ((GlobalOrdinalsIndexFieldData)fieldData).newConsumer(indexReader);
        }
        return fieldData;
    }

    private IndexOrdinalsFieldData loadGlobalInternal(DirectoryReader indexReader) {
        if (indexReader.leaves().size() <= 1) {
            return this;
        }
        boolean fieldFound = false;
        for (LeafReaderContext context : indexReader.leaves()) {
            if (context.reader().getFieldInfos().fieldInfo(this.getFieldName()) == null) continue;
            fieldFound = true;
            break;
        }
        if (!fieldFound) {
            try {
                return GlobalOrdinalsBuilder.buildEmpty(this.indexSettings, indexReader, this);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        try {
            return this.cache.load(indexReader, this);
        }
        catch (Exception e) {
            if (e instanceof ElasticsearchException) {
                throw (ElasticsearchException)e;
            }
            throw new ElasticsearchException(e);
        }
    }

    @Override
    public IndexOrdinalsFieldData localGlobalDirect(DirectoryReader indexReader) throws Exception {
        return GlobalOrdinalsBuilder.build(indexReader, this, this.indexSettings, this.breakerService, logger, this.scriptFunction);
    }

    @Override
    public OrdinalMap getOrdinalMap() {
        return null;
    }

    @Override
    public boolean supportsGlobalOrdinalsMapping() {
        return true;
    }
}

