/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.fielddata.plain;

import java.util.Collections;
import java.util.Set;
import java.util.function.Function;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.IndexReader;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.SortedSetDocValues;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.util.set.Sets;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.Index;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.IndexSettings;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.fielddata.IndexFieldData;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.fielddata.IndexFieldDataCache;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.fielddata.IndexNumericFieldData;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.fielddata.ScriptDocValues;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.fielddata.plain.AbstractAtomicOrdinalsFieldData;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.fielddata.plain.BinaryDVIndexFieldData;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.fielddata.plain.SortedNumericDVIndexFieldData;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.fielddata.plain.SortedSetDVOrdinalsIndexFieldData;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper.MappedFieldType;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper.MapperService;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper.RangeType;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.indices.breaker.CircuitBreakerService;

public abstract class DocValuesIndexFieldData {
    protected final Index index;
    protected final String fieldName;

    public DocValuesIndexFieldData(Index index, String fieldName) {
        this.index = index;
        this.fieldName = fieldName;
    }

    public final String getFieldName() {
        return this.fieldName;
    }

    public final void clear() {
    }

    public final void clear(IndexReader reader) {
    }

    public final Index index() {
        return this.index;
    }

    public static class Builder
    implements IndexFieldData.Builder {
        private static final Set<String> BINARY_INDEX_FIELD_NAMES = Collections.unmodifiableSet(Sets.newHashSet("_id"));
        private IndexNumericFieldData.NumericType numericType;
        private Function<SortedSetDocValues, ScriptDocValues<?>> scriptFunction = AbstractAtomicOrdinalsFieldData.DEFAULT_SCRIPT_FUNCTION;
        private RangeType rangeType;

        public Builder numericType(IndexNumericFieldData.NumericType type) {
            this.numericType = type;
            return this;
        }

        public Builder scriptFunction(Function<SortedSetDocValues, ScriptDocValues<?>> scriptFunction) {
            this.scriptFunction = scriptFunction;
            return this;
        }

        public Builder setRangeType(RangeType rangeType) {
            this.rangeType = rangeType;
            return this;
        }

        @Override
        public IndexFieldData<?> build(IndexSettings indexSettings, MappedFieldType fieldType, IndexFieldDataCache cache, CircuitBreakerService breakerService, MapperService mapperService) {
            String fieldName = fieldType.name();
            if (BINARY_INDEX_FIELD_NAMES.contains(fieldName) || this.rangeType != null) {
                assert (this.numericType == null);
                return new BinaryDVIndexFieldData(indexSettings.getIndex(), fieldName);
            }
            if (this.numericType != null) {
                return new SortedNumericDVIndexFieldData(indexSettings.getIndex(), fieldName, this.numericType);
            }
            return new SortedSetDVOrdinalsIndexFieldData(indexSettings, cache, fieldName, breakerService, this.scriptFunction);
        }
    }
}

