/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.gateway;

import java.util.Comparator;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.metadata.IndexMetaData;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.routing.ShardRouting;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.routing.allocation.RoutingAllocation;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.settings.Settings;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.Index;

public abstract class PriorityComparator
implements Comparator<ShardRouting> {
    @Override
    public final int compare(ShardRouting o1, ShardRouting o2) {
        String o1Index = o1.getIndexName();
        String o2Index = o2.getIndexName();
        int cmp = 0;
        if (!o1Index.equals(o2Index)) {
            Settings settingsO1 = this.getIndexSettings(o1.index());
            Settings settingsO2 = this.getIndexSettings(o2.index());
            cmp = Long.compare(PriorityComparator.priority(settingsO2), PriorityComparator.priority(settingsO1));
            if (cmp == 0 && (cmp = Long.compare(PriorityComparator.timeCreated(settingsO2), PriorityComparator.timeCreated(settingsO1))) == 0) {
                cmp = o2Index.compareTo(o1Index);
            }
        }
        return cmp;
    }

    private static int priority(Settings settings) {
        return IndexMetaData.INDEX_PRIORITY_SETTING.get(settings);
    }

    private static long timeCreated(Settings settings) {
        return settings.getAsLong("index.creation_date", -1L);
    }

    protected abstract Settings getIndexSettings(Index var1);

    public static PriorityComparator getAllocationComparator(final RoutingAllocation allocation) {
        return new PriorityComparator(){

            @Override
            protected Settings getIndexSettings(Index index) {
                IndexMetaData indexMetaData = allocation.metaData().getIndexSafe(index);
                return indexMetaData.getSettings();
            }
        };
    }
}

