/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.gateway;

import java.util.Map;
import org.apache.flink.elasticsearch7.shaded.com.carrotsearch.hppc.cursors.ObjectCursor;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.ClusterState;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.block.ClusterBlocks;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.metadata.IndexMetaData;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.metadata.MetaData;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.node.DiscoveryNode;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.node.DiscoveryNodes;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.routing.RoutingTable;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.settings.ClusterSettings;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.gateway.GatewayService;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;

public class ClusterStateUpdaters {
    private static final Logger logger = LogManager.getLogger(ClusterStateUpdaters.class);

    static ClusterState setLocalNode(ClusterState clusterState, DiscoveryNode localNode) {
        return ClusterState.builder(clusterState).nodes(DiscoveryNodes.builder().add(localNode).localNodeId(localNode.getId()).build()).build();
    }

    static ClusterState upgradeAndArchiveUnknownOrInvalidSettings(ClusterState clusterState, ClusterSettings clusterSettings) {
        MetaData.Builder metaDataBuilder = MetaData.builder(clusterState.metaData());
        metaDataBuilder.persistentSettings(clusterSettings.archiveUnknownOrInvalidSettings(clusterSettings.upgradeSettings(metaDataBuilder.persistentSettings()), e -> ClusterStateUpdaters.logUnknownSetting("persistent", e), (e, ex) -> ClusterStateUpdaters.logInvalidSetting("persistent", e, ex)));
        metaDataBuilder.transientSettings(clusterSettings.archiveUnknownOrInvalidSettings(clusterSettings.upgradeSettings(metaDataBuilder.transientSettings()), e -> ClusterStateUpdaters.logUnknownSetting("transient", e), (e, ex) -> ClusterStateUpdaters.logInvalidSetting("transient", e, ex)));
        return ClusterState.builder(clusterState).metaData(metaDataBuilder).build();
    }

    private static void logUnknownSetting(String settingType, Map.Entry<String, String> e) {
        logger.warn("ignoring unknown {} setting: [{}] with value [{}]; archiving", (Object)settingType, (Object)e.getKey(), (Object)e.getValue());
    }

    private static void logInvalidSetting(String settingType, Map.Entry<String, String> e, IllegalArgumentException ex) {
        logger.warn(() -> new ParameterizedMessage("ignoring invalid {} setting: [{}] with value [{}]; archiving", new Object[]{settingType, e.getKey(), e.getValue()}), (Throwable)ex);
    }

    static ClusterState recoverClusterBlocks(ClusterState state) {
        ClusterBlocks.Builder blocks = ClusterBlocks.builder().blocks(state.blocks());
        if (MetaData.SETTING_READ_ONLY_SETTING.get(state.metaData().settings()).booleanValue()) {
            blocks.addGlobalBlock(MetaData.CLUSTER_READ_ONLY_BLOCK);
        }
        if (MetaData.SETTING_READ_ONLY_ALLOW_DELETE_SETTING.get(state.metaData().settings()).booleanValue()) {
            blocks.addGlobalBlock(MetaData.CLUSTER_READ_ONLY_ALLOW_DELETE_BLOCK);
        }
        for (IndexMetaData indexMetaData : state.metaData()) {
            blocks.addBlocks(indexMetaData);
        }
        return ClusterState.builder(state).blocks(blocks).build();
    }

    static ClusterState updateRoutingTable(ClusterState state) {
        RoutingTable.Builder routingTableBuilder = RoutingTable.builder(state.routingTable());
        for (ObjectCursor<IndexMetaData> objectCursor : state.metaData().indices().values()) {
            routingTableBuilder.addAsRecovery((IndexMetaData)objectCursor.value);
        }
        routingTableBuilder.version(0L);
        return ClusterState.builder(state).routingTable(routingTableBuilder.build()).build();
    }

    static ClusterState removeStateNotRecoveredBlock(ClusterState state) {
        return ClusterState.builder(state).blocks(ClusterBlocks.builder().blocks(state.blocks()).removeGlobalBlock(GatewayService.STATE_NOT_RECOVERED_BLOCK).build()).build();
    }

    public static ClusterState addStateNotRecoveredBlock(ClusterState state) {
        return ClusterState.builder(state).blocks(ClusterBlocks.builder().blocks(state.blocks()).addGlobalBlock(GatewayService.STATE_NOT_RECOVERED_BLOCK).build()).build();
    }

    static ClusterState mixCurrentStateAndRecoveredState(ClusterState currentState, ClusterState recoveredState) {
        assert (currentState.metaData().indices().isEmpty());
        ClusterBlocks.Builder blocks = ClusterBlocks.builder().blocks(currentState.blocks()).blocks(recoveredState.blocks());
        MetaData.Builder metaDataBuilder = MetaData.builder(recoveredState.metaData());
        metaDataBuilder.generateClusterUuidIfNeeded();
        for (IndexMetaData indexMetaData : recoveredState.metaData()) {
            metaDataBuilder.put(indexMetaData, false);
        }
        return ClusterState.builder(currentState).blocks(blocks).metaData(metaDataBuilder).build();
    }

    public static ClusterState hideStateIfNotRecovered(ClusterState state) {
        if (state.blocks().hasGlobalBlock(GatewayService.STATE_NOT_RECOVERED_BLOCK)) {
            ClusterBlocks.Builder blocks = ClusterBlocks.builder().blocks(state.blocks());
            blocks.removeGlobalBlock(MetaData.CLUSTER_READ_ONLY_BLOCK);
            blocks.removeGlobalBlock(MetaData.CLUSTER_READ_ONLY_ALLOW_DELETE_BLOCK);
            for (IndexMetaData indexMetaData : state.metaData()) {
                blocks.removeIndexBlocks(indexMetaData.getIndex().getName());
            }
            MetaData metaData = MetaData.builder().clusterUUID(state.metaData().clusterUUID()).coordinationMetaData(state.metaData().coordinationMetaData()).build();
            return ClusterState.builder(state).metaData(metaData).blocks(blocks.build()).build();
        }
        return state;
    }
}

