/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.util.concurrent;

import java.util.concurrent.BlockingQueue;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.util.concurrent.SizeBlockingQueue;

final class ResizableBlockingQueue<E>
extends SizeBlockingQueue<E> {
    private volatile int capacity;

    ResizableBlockingQueue(BlockingQueue<E> queue, int initialCapacity) {
        super(queue, initialCapacity);
        this.capacity = initialCapacity;
    }

    @Override
    public int capacity() {
        return this.capacity;
    }

    @Override
    public int remainingCapacity() {
        return Math.max(0, this.capacity());
    }

    public synchronized int adjustCapacity(int optimalCapacity, int adjustmentAmount, int minCapacity, int maxCapacity) {
        assert (adjustmentAmount > 0) : "adjustment amount should be a positive value";
        assert (optimalCapacity >= 0) : "desired capacity cannot be negative";
        assert (minCapacity >= 0) : "cannot have min capacity smaller than 0";
        assert (maxCapacity >= minCapacity) : "cannot have max capacity smaller than min capacity";
        if (optimalCapacity == this.capacity) {
            return this.capacity;
        }
        if (optimalCapacity > this.capacity + adjustmentAmount) {
            int newCapacity;
            this.capacity = newCapacity = Math.min(maxCapacity, this.capacity + adjustmentAmount);
            return newCapacity;
        }
        if (optimalCapacity < this.capacity - adjustmentAmount) {
            int newCapacity;
            this.capacity = newCapacity = Math.max(minCapacity, this.capacity - adjustmentAmount);
            return newCapacity;
        }
        return this.capacity;
    }
}

