/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.settings;

import joptsimple.OptionSet;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cli.EnvironmentAwareCommand;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cli.Terminal;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cli.UserException;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.settings.KeyStoreWrapper;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.env.Environment;

public class UpgradeKeyStoreCommand
extends EnvironmentAwareCommand {
    UpgradeKeyStoreCommand() {
        super("Upgrade the keystore format");
    }

    @Override
    protected void execute(Terminal terminal, OptionSet options, Environment env) throws Exception {
        KeyStoreWrapper wrapper = KeyStoreWrapper.load(env.configFile());
        if (wrapper == null) {
            throw new UserException(78, "keystore does not exist at [" + KeyStoreWrapper.keystorePath(env.configFile()) + "]");
        }
        wrapper.decrypt(new char[0]);
        KeyStoreWrapper.upgrade(wrapper, env.configFile(), new char[0]);
    }
}

