/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common;

import java.util.concurrent.atomic.AtomicLong;

public class ExponentiallyWeightedMovingAverage {
    private final double alpha;
    private final AtomicLong averageBits;

    public ExponentiallyWeightedMovingAverage(double alpha, double initialAvg) {
        if (alpha < 0.0 || alpha > 1.0) {
            throw new IllegalArgumentException("alpha must be greater or equal to 0 and less than or equal to 1");
        }
        this.alpha = alpha;
        this.averageBits = new AtomicLong(Double.doubleToLongBits(initialAvg));
    }

    public double getAverage() {
        return Double.longBitsToDouble(this.averageBits.get());
    }

    public void addValue(double newValue) {
        double currentAvg;
        double newAvg;
        long newBits;
        long currentBits;
        boolean successful = false;
        while (!(successful = this.averageBits.compareAndSet(currentBits = this.averageBits.get(), newBits = Double.doubleToLongBits(newAvg = this.alpha * newValue + (1.0 - this.alpha) * (currentAvg = this.getAverage()))))) {
        }
    }
}

