/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.Version;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.AbstractNamedDiffable;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.ClusterState;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.NamedDiff;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.io.stream.StreamInput;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.io.stream.StreamOutput;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.io.stream.Writeable;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.unit.TimeValue;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ToXContent;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentBuilder;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.snapshots.Snapshot;

public class SnapshotDeletionsInProgress
extends AbstractNamedDiffable<ClusterState.Custom>
implements ClusterState.Custom {
    public static final String TYPE = "snapshot_deletions";
    private final List<Entry> entries;

    public SnapshotDeletionsInProgress(List<Entry> entries) {
        this.entries = Collections.unmodifiableList(entries);
    }

    public SnapshotDeletionsInProgress(StreamInput in) throws IOException {
        this.entries = Collections.unmodifiableList(in.readList(Entry::new));
    }

    public static SnapshotDeletionsInProgress newInstance(Entry entry) {
        return new SnapshotDeletionsInProgress(Collections.singletonList(entry));
    }

    public SnapshotDeletionsInProgress withAddedEntry(Entry entry) {
        ArrayList<Entry> entries = new ArrayList<Entry>(this.getEntries());
        entries.add(entry);
        return new SnapshotDeletionsInProgress(entries);
    }

    public SnapshotDeletionsInProgress withRemovedEntry(Entry entry) {
        ArrayList<Entry> entries = new ArrayList<Entry>(this.getEntries());
        entries.remove(entry);
        return new SnapshotDeletionsInProgress(entries);
    }

    public List<Entry> getEntries() {
        return this.entries;
    }

    public boolean hasDeletionsInProgress() {
        return !this.entries.isEmpty();
    }

    @Override
    public String getWriteableName() {
        return TYPE;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SnapshotDeletionsInProgress that = (SnapshotDeletionsInProgress)o;
        return this.entries.equals(that.entries);
    }

    public int hashCode() {
        return 31 + this.entries.hashCode();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeList(this.entries);
    }

    public static NamedDiff<ClusterState.Custom> readDiffFrom(StreamInput in) throws IOException {
        return SnapshotDeletionsInProgress.readDiffFrom(ClusterState.Custom.class, TYPE, in);
    }

    @Override
    public Version getMinimalSupportedVersion() {
        return Version.CURRENT.minimumCompatibilityVersion();
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startArray(TYPE);
        for (Entry entry : this.entries) {
            builder.startObject();
            builder.field("repository", entry.snapshot.getRepository());
            builder.field("snapshot", entry.snapshot.getSnapshotId().getName());
            builder.humanReadableField("start_time_millis", "start_time", new TimeValue(entry.startTime));
            builder.field("repository_state_id", entry.repositoryStateId);
            builder.endObject();
        }
        builder.endArray();
        return builder;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("SnapshotDeletionsInProgress[");
        for (int i = 0; i < this.entries.size(); ++i) {
            builder.append(this.entries.get(i).getSnapshot().getSnapshotId().getName());
            if (i + 1 >= this.entries.size()) continue;
            builder.append(",");
        }
        return builder.append("]").toString();
    }

    public static final class Entry
    implements Writeable {
        private final Snapshot snapshot;
        private final long startTime;
        private final long repositoryStateId;

        public Entry(Snapshot snapshot, long startTime, long repositoryStateId) {
            this.snapshot = snapshot;
            this.startTime = startTime;
            this.repositoryStateId = repositoryStateId;
        }

        public Entry(StreamInput in) throws IOException {
            this.snapshot = new Snapshot(in);
            this.startTime = in.readVLong();
            this.repositoryStateId = in.readLong();
        }

        public Snapshot getSnapshot() {
            return this.snapshot;
        }

        public long getStartTime() {
            return this.startTime;
        }

        public long getRepositoryStateId() {
            return this.repositoryStateId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Entry that = (Entry)o;
            return this.snapshot.equals(that.snapshot) && this.startTime == that.startTime && this.repositoryStateId == that.repositoryStateId;
        }

        public int hashCode() {
            return Objects.hash(this.snapshot, this.startTime, this.repositoryStateId);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            this.snapshot.writeTo(out);
            out.writeVLong(this.startTime);
            out.writeLong(this.repositoryStateId);
        }
    }
}

