/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.ml;

import java.io.IOException;
import java.util.Objects;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.ml.job.process.ModelSnapshot;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.ParseField;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ToXContent;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ToXContentObject;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentBuilder;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentParser;

public class UpdateModelSnapshotResponse
implements ToXContentObject {
    private static final ParseField ACKNOWLEDGED = new ParseField("acknowledged", new String[0]);
    private static final ParseField MODEL = new ParseField("model", new String[0]);
    public static final ConstructingObjectParser<UpdateModelSnapshotResponse, Void> PARSER = new ConstructingObjectParser("update_model_snapshot_response", true, a -> new UpdateModelSnapshotResponse((Boolean)a[0], (ModelSnapshot.Builder)a[1]));
    private final Boolean acknowledged;
    private final ModelSnapshot model;

    public UpdateModelSnapshotResponse(boolean acknowledged, ModelSnapshot.Builder modelSnapshot) {
        this.acknowledged = acknowledged;
        this.model = modelSnapshot.build();
    }

    public static UpdateModelSnapshotResponse fromXContent(XContentParser parser) throws IOException {
        return PARSER.parse(parser, null);
    }

    public Boolean getAcknowledged() {
        return this.acknowledged;
    }

    public ModelSnapshot getModel() {
        return this.model;
    }

    public int hashCode() {
        return Objects.hash(this.acknowledged, this.model);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.acknowledged != null) {
            builder.field(ACKNOWLEDGED.getPreferredName(), this.acknowledged);
        }
        if (this.model != null) {
            builder.field(MODEL.getPreferredName(), this.model);
        }
        builder.endObject();
        return builder;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UpdateModelSnapshotResponse request = (UpdateModelSnapshotResponse)obj;
        return Objects.equals(this.acknowledged, request.acknowledged) && Objects.equals(this.model, request.model);
    }

    static {
        PARSER.declareBoolean(ConstructingObjectParser.constructorArg(), ACKNOWLEDGED);
        PARSER.declareObject(ConstructingObjectParser.constructorArg(), ModelSnapshot.PARSER, MODEL);
    }
}

