/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.ml;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.Validatable;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.ValidationException;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.core.PageParams;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.Nullable;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.ParseField;

public class GetDataFrameAnalyticsStatsRequest
implements Validatable {
    public static final ParseField ALLOW_NO_MATCH = new ParseField("allow_no_match", new String[0]);
    private final List<String> ids;
    private Boolean allowNoMatch;
    private PageParams pageParams;

    public GetDataFrameAnalyticsStatsRequest(String ... ids) {
        this.ids = Arrays.asList(ids);
    }

    public List<String> getIds() {
        return this.ids;
    }

    public Boolean getAllowNoMatch() {
        return this.allowNoMatch;
    }

    public GetDataFrameAnalyticsStatsRequest setAllowNoMatch(boolean allowNoMatch) {
        this.allowNoMatch = allowNoMatch;
        return this;
    }

    public PageParams getPageParams() {
        return this.pageParams;
    }

    public GetDataFrameAnalyticsStatsRequest setPageParams(@Nullable PageParams pageParams) {
        this.pageParams = pageParams;
        return this;
    }

    @Override
    public Optional<ValidationException> validate() {
        if (this.ids == null || this.ids.isEmpty()) {
            return Optional.of(ValidationException.withError("data frame analytics id must not be null"));
        }
        return Optional.empty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetDataFrameAnalyticsStatsRequest other = (GetDataFrameAnalyticsStatsRequest)o;
        return Objects.equals(this.ids, other.ids) && Objects.equals(this.allowNoMatch, other.allowNoMatch) && Objects.equals(this.pageParams, other.pageParams);
    }

    public int hashCode() {
        return Objects.hash(this.ids, this.allowNoMatch, this.pageParams);
    }
}

