/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.ml;

import java.io.IOException;
import java.util.Objects;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.Nullable;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.ParseField;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ObjectParser;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ToXContent;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ToXContentObject;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentBuilder;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentParser;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.tasks.TaskId;

public class DeleteJobResponse
implements ToXContentObject {
    private static final ParseField ACKNOWLEDGED = new ParseField("acknowledged", new String[0]);
    private static final ParseField TASK = new ParseField("task", new String[0]);
    public static final ConstructingObjectParser<DeleteJobResponse, Void> PARSER = new ConstructingObjectParser("delete_job_response", true, a -> new DeleteJobResponse((Boolean)a[0], (TaskId)a[1]));
    private final Boolean acknowledged;
    private final TaskId task;

    public static DeleteJobResponse fromXContent(XContentParser parser) throws IOException {
        return PARSER.parse(parser, null);
    }

    DeleteJobResponse(@Nullable Boolean acknowledged, @Nullable TaskId task) {
        assert (acknowledged != null || task != null);
        this.acknowledged = acknowledged;
        this.task = task;
    }

    public Boolean getAcknowledged() {
        return this.acknowledged;
    }

    public TaskId getTask() {
        return this.task;
    }

    public int hashCode() {
        return Objects.hash(this.acknowledged, this.task);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        DeleteJobResponse that = (DeleteJobResponse)other;
        return Objects.equals(this.acknowledged, that.acknowledged) && Objects.equals(this.task, that.task);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.acknowledged != null) {
            builder.field(ACKNOWLEDGED.getPreferredName(), this.acknowledged);
        }
        if (this.task != null) {
            builder.field(TASK.getPreferredName(), this.task.toString());
        }
        builder.endObject();
        return builder;
    }

    static {
        PARSER.declareBoolean(ConstructingObjectParser.optionalConstructorArg(), ACKNOWLEDGED);
        PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), TaskId.parser(), TASK, ObjectParser.ValueType.STRING);
    }
}

