/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.indices;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.CollectionUtil;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.metadata.AliasMetaData;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.metadata.MappingMetaData;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.settings.Settings;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentParser;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentParserUtils;

public class GetIndexResponse {
    private Map<String, MappingMetaData> mappings;
    private Map<String, List<AliasMetaData>> aliases;
    private Map<String, Settings> settings;
    private Map<String, Settings> defaultSettings;
    private String[] indices;

    GetIndexResponse(String[] indices, Map<String, MappingMetaData> mappings, Map<String, List<AliasMetaData>> aliases, Map<String, Settings> settings, Map<String, Settings> defaultSettings) {
        this.indices = indices;
        Arrays.sort(indices);
        if (mappings != null) {
            this.mappings = mappings;
        }
        if (aliases != null) {
            this.aliases = aliases;
        }
        if (settings != null) {
            this.settings = settings;
        }
        if (defaultSettings != null) {
            this.defaultSettings = defaultSettings;
        }
    }

    public String[] getIndices() {
        return this.indices;
    }

    public Map<String, MappingMetaData> getMappings() {
        return this.mappings;
    }

    public Map<String, List<AliasMetaData>> getAliases() {
        return this.aliases;
    }

    public Map<String, Settings> getDefaultSettings() {
        return this.defaultSettings;
    }

    public Map<String, Settings> getSettings() {
        return this.settings;
    }

    public String getSetting(String index, String setting) {
        Settings indexSettings = this.settings.get(index);
        if (setting != null) {
            if (indexSettings != null && indexSettings.hasValue(setting)) {
                return indexSettings.get(setting);
            }
            Settings defaultIndexSettings = this.defaultSettings.get(index);
            if (defaultIndexSettings != null) {
                return defaultIndexSettings.get(setting);
            }
            return null;
        }
        return null;
    }

    private static List<AliasMetaData> parseAliases(XContentParser parser) throws IOException {
        ArrayList<AliasMetaData> indexAliases = new ArrayList<AliasMetaData>();
        while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            XContentParserUtils.ensureExpectedToken(XContentParser.Token.FIELD_NAME, parser.currentToken(), parser::getTokenLocation);
            indexAliases.add(AliasMetaData.Builder.fromXContent(parser));
        }
        return indexAliases;
    }

    private static MappingMetaData parseMappings(XContentParser parser) throws IOException {
        return new MappingMetaData("_doc", parser.map());
    }

    private static IndexEntry parseIndexEntry(XContentParser parser) throws IOException {
        List<AliasMetaData> indexAliases = null;
        MappingMetaData indexMappings = null;
        Settings indexSettings = null;
        Settings indexDefaultSettings = null;
        block12: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            XContentParserUtils.ensureExpectedToken(XContentParser.Token.FIELD_NAME, parser.currentToken(), parser::getTokenLocation);
            parser.nextToken();
            if (parser.currentToken() == XContentParser.Token.START_OBJECT) {
                switch (parser.currentName()) {
                    case "aliases": {
                        indexAliases = GetIndexResponse.parseAliases(parser);
                        continue block12;
                    }
                    case "mappings": {
                        indexMappings = GetIndexResponse.parseMappings(parser);
                        continue block12;
                    }
                    case "settings": {
                        indexSettings = Settings.fromXContent(parser);
                        continue block12;
                    }
                    case "defaults": {
                        indexDefaultSettings = Settings.fromXContent(parser);
                        continue block12;
                    }
                }
                parser.skipChildren();
                continue;
            }
            if (parser.currentToken() != XContentParser.Token.START_ARRAY) continue;
            parser.skipChildren();
        }
        return new IndexEntry(indexAliases, indexMappings, indexSettings, indexDefaultSettings);
    }

    public static GetIndexResponse fromXContent(XContentParser parser) throws IOException {
        HashMap<String, List<AliasMetaData>> aliases = new HashMap<String, List<AliasMetaData>>();
        HashMap<String, MappingMetaData> mappings = new HashMap<String, MappingMetaData>();
        HashMap<String, Settings> settings = new HashMap<String, Settings>();
        HashMap<String, Settings> defaultSettings = new HashMap<String, Settings>();
        ArrayList<String> indices = new ArrayList<String>();
        if (parser.currentToken() == null) {
            parser.nextToken();
        }
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_OBJECT, parser.currentToken(), parser::getTokenLocation);
        parser.nextToken();
        while (!parser.isClosed()) {
            if (parser.currentToken() == XContentParser.Token.START_OBJECT) {
                String indexName = parser.currentName();
                indices.add(indexName);
                IndexEntry indexEntry = GetIndexResponse.parseIndexEntry(parser);
                CollectionUtil.timSort(indexEntry.indexAliases, Comparator.comparing(AliasMetaData::alias));
                aliases.put(indexName, Collections.unmodifiableList(indexEntry.indexAliases));
                mappings.put(indexName, indexEntry.indexMappings);
                settings.put(indexName, indexEntry.indexSettings);
                if (indexEntry.indexDefaultSettings.isEmpty()) continue;
                defaultSettings.put(indexName, indexEntry.indexDefaultSettings);
                continue;
            }
            if (parser.currentToken() == XContentParser.Token.START_ARRAY) {
                parser.skipChildren();
                continue;
            }
            parser.nextToken();
        }
        return new GetIndexResponse(indices.toArray(new String[0]), mappings, aliases, settings, defaultSettings);
    }

    private static class IndexEntry {
        List<AliasMetaData> indexAliases = new ArrayList<AliasMetaData>();
        MappingMetaData indexMappings;
        Settings indexSettings = Settings.EMPTY;
        Settings indexDefaultSettings = Settings.EMPTY;

        IndexEntry(List<AliasMetaData> indexAliases, MappingMetaData indexMappings, Settings indexSettings, Settings indexDefaultSettings) {
            if (indexAliases != null) {
                this.indexAliases = indexAliases;
            }
            if (indexMappings != null) {
                this.indexMappings = indexMappings;
            }
            if (indexSettings != null) {
                this.indexSettings = indexSettings;
            }
            if (indexDefaultSettings != null) {
                this.indexDefaultSettings = indexDefaultSettings;
            }
        }
    }
}

