/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.indexlifecycle;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.indexlifecycle.Phase;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.ParseField;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.Strings;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.util.set.Sets;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ToXContent;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ToXContentObject;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentBuilder;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentParser;

public class LifecyclePolicy
implements ToXContentObject {
    static final ParseField PHASES_FIELD = new ParseField("phases", new String[0]);
    public static ConstructingObjectParser<LifecyclePolicy, String> PARSER = new ConstructingObjectParser<LifecyclePolicy, String>("lifecycle_policy", true, (a, name) -> {
        List phases = (List)a[0];
        Map<String, Phase> phaseMap = phases.stream().collect(Collectors.toMap(Phase::getName, Function.identity()));
        return new LifecyclePolicy((String)name, phaseMap);
    });
    private static Map<String, Set<String>> ALLOWED_ACTIONS = new HashMap<String, Set<String>>();
    private final String name;
    private final Map<String, Phase> phases;

    public LifecyclePolicy(String name, Map<String, Phase> phases) {
        phases.values().forEach(phase -> {
            if (!ALLOWED_ACTIONS.containsKey(phase.getName())) {
                throw new IllegalArgumentException("Lifecycle does not support phase [" + phase.getName() + "]");
            }
            phase.getActions().forEach((actionName, action) -> {
                if (!ALLOWED_ACTIONS.get(phase.getName()).contains(actionName)) {
                    throw new IllegalArgumentException("invalid action [" + actionName + "] defined in phase [" + phase.getName() + "]");
                }
            });
        });
        this.name = name;
        this.phases = phases;
    }

    public static LifecyclePolicy parse(XContentParser parser, String name) {
        return PARSER.apply(parser, name);
    }

    public String getName() {
        return this.name;
    }

    public Map<String, Phase> getPhases() {
        return this.phases;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.startObject(PHASES_FIELD.getPreferredName());
        for (Phase phase : this.phases.values()) {
            builder.field(phase.getName(), phase);
        }
        builder.endObject();
        builder.endObject();
        return builder;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.phases);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        LifecyclePolicy other = (LifecyclePolicy)obj;
        return Objects.equals(this.name, other.name) && Objects.equals(this.phases, other.phases);
    }

    public String toString() {
        return Strings.toString(this, true, true);
    }

    static {
        PARSER.declareNamedObjects(ConstructingObjectParser.constructorArg(), (p, c, n) -> Phase.parse(p, n), v -> {
            throw new IllegalArgumentException("ordered " + PHASES_FIELD.getPreferredName() + " are not supported");
        }, PHASES_FIELD);
        ALLOWED_ACTIONS.put("hot", Sets.newHashSet("unfollow", "set_priority", "rollover"));
        ALLOWED_ACTIONS.put("warm", Sets.newHashSet("unfollow", "set_priority", "allocate", "forcemerge", "readonly", "shrink"));
        ALLOWED_ACTIONS.put("cold", Sets.newHashSet("unfollow", "set_priority", "allocate", "freeze"));
        ALLOWED_ACTIONS.put("delete", Sets.newHashSet("delete"));
    }
}

