/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client;

import java.io.IOException;
import java.util.Collections;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.ActionListener;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.Cancellable;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.RequestOptions;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.RestHighLevelClient;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.SecurityRequestConverters;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.security.AuthenticateRequest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.security.AuthenticateResponse;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.security.ChangePasswordRequest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.security.ClearRealmCacheRequest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.security.ClearRealmCacheResponse;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.security.ClearRolesCacheRequest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.security.ClearRolesCacheResponse;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.security.CreateApiKeyRequest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.security.CreateApiKeyResponse;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.security.CreateTokenRequest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.security.CreateTokenResponse;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.security.DelegatePkiAuthenticationRequest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.security.DelegatePkiAuthenticationResponse;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.security.DeletePrivilegesRequest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.security.DeletePrivilegesResponse;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.security.DeleteRoleMappingRequest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.security.DeleteRoleMappingResponse;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.security.DeleteRoleRequest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.security.DeleteRoleResponse;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.security.DeleteUserRequest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.security.DeleteUserResponse;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.security.DisableUserRequest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.security.EnableUserRequest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.security.GetApiKeyRequest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.security.GetApiKeyResponse;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.security.GetBuiltinPrivilegesRequest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.security.GetBuiltinPrivilegesResponse;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.security.GetPrivilegesRequest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.security.GetPrivilegesResponse;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.security.GetRoleMappingsRequest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.security.GetRoleMappingsResponse;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.security.GetRolesRequest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.security.GetRolesResponse;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.security.GetSslCertificatesRequest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.security.GetSslCertificatesResponse;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.security.GetUserPrivilegesRequest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.security.GetUserPrivilegesResponse;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.security.GetUsersRequest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.security.GetUsersResponse;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.security.HasPrivilegesRequest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.security.HasPrivilegesResponse;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.security.InvalidateApiKeyRequest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.security.InvalidateApiKeyResponse;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.security.InvalidateTokenRequest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.security.InvalidateTokenResponse;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.security.PutPrivilegesRequest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.security.PutPrivilegesResponse;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.security.PutRoleMappingRequest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.security.PutRoleMappingResponse;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.security.PutRoleRequest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.security.PutRoleResponse;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.security.PutUserRequest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.security.PutUserResponse;

public final class SecurityClient {
    private final RestHighLevelClient restHighLevelClient;

    SecurityClient(RestHighLevelClient restHighLevelClient) {
        this.restHighLevelClient = restHighLevelClient;
    }

    public GetUsersResponse getUsers(GetUsersRequest request, RequestOptions options) throws IOException {
        return this.restHighLevelClient.performRequestAndParseEntity(request, SecurityRequestConverters::getUsers, options, GetUsersResponse::fromXContent, Collections.emptySet());
    }

    public Cancellable getUsersAsync(GetUsersRequest request, RequestOptions options, ActionListener<GetUsersResponse> listener) {
        return this.restHighLevelClient.performRequestAsyncAndParseEntity(request, SecurityRequestConverters::getUsers, options, GetUsersResponse::fromXContent, listener, Collections.emptySet());
    }

    public PutUserResponse putUser(PutUserRequest request, RequestOptions options) throws IOException {
        return this.restHighLevelClient.performRequestAndParseEntity(request, SecurityRequestConverters::putUser, options, PutUserResponse::fromXContent, Collections.emptySet());
    }

    public Cancellable putUserAsync(PutUserRequest request, RequestOptions options, ActionListener<PutUserResponse> listener) {
        return this.restHighLevelClient.performRequestAsyncAndParseEntity(request, SecurityRequestConverters::putUser, options, PutUserResponse::fromXContent, listener, Collections.emptySet());
    }

    public DeleteUserResponse deleteUser(DeleteUserRequest request, RequestOptions options) throws IOException {
        return this.restHighLevelClient.performRequestAndParseEntity(request, SecurityRequestConverters::deleteUser, options, DeleteUserResponse::fromXContent, Collections.singleton(404));
    }

    public Cancellable deleteUserAsync(DeleteUserRequest request, RequestOptions options, ActionListener<DeleteUserResponse> listener) {
        return this.restHighLevelClient.performRequestAsyncAndParseEntity(request, SecurityRequestConverters::deleteUser, options, DeleteUserResponse::fromXContent, listener, Collections.singleton(404));
    }

    public PutRoleMappingResponse putRoleMapping(PutRoleMappingRequest request, RequestOptions options) throws IOException {
        return this.restHighLevelClient.performRequestAndParseEntity(request, SecurityRequestConverters::putRoleMapping, options, PutRoleMappingResponse::fromXContent, Collections.emptySet());
    }

    public Cancellable putRoleMappingAsync(PutRoleMappingRequest request, RequestOptions options, ActionListener<PutRoleMappingResponse> listener) {
        return this.restHighLevelClient.performRequestAsyncAndParseEntity(request, SecurityRequestConverters::putRoleMapping, options, PutRoleMappingResponse::fromXContent, listener, Collections.emptySet());
    }

    public GetRoleMappingsResponse getRoleMappings(GetRoleMappingsRequest request, RequestOptions options) throws IOException {
        return this.restHighLevelClient.performRequestAndParseEntity(request, SecurityRequestConverters::getRoleMappings, options, GetRoleMappingsResponse::fromXContent, Collections.emptySet());
    }

    public Cancellable getRoleMappingsAsync(GetRoleMappingsRequest request, RequestOptions options, ActionListener<GetRoleMappingsResponse> listener) {
        return this.restHighLevelClient.performRequestAsyncAndParseEntity(request, SecurityRequestConverters::getRoleMappings, options, GetRoleMappingsResponse::fromXContent, listener, Collections.emptySet());
    }

    public boolean enableUser(EnableUserRequest request, RequestOptions options) throws IOException {
        return this.restHighLevelClient.performRequest(request, SecurityRequestConverters::enableUser, options, RestHighLevelClient::convertExistsResponse, Collections.emptySet());
    }

    @Deprecated
    public boolean enableUser(RequestOptions options, EnableUserRequest request) throws IOException {
        return this.enableUser(request, options);
    }

    public Cancellable enableUserAsync(EnableUserRequest request, RequestOptions options, ActionListener<Boolean> listener) {
        return this.restHighLevelClient.performRequestAsync(request, SecurityRequestConverters::enableUser, options, RestHighLevelClient::convertExistsResponse, listener, Collections.emptySet());
    }

    @Deprecated
    public Cancellable enableUserAsync(RequestOptions options, EnableUserRequest request, ActionListener<Boolean> listener) {
        return this.enableUserAsync(request, options, listener);
    }

    public boolean disableUser(DisableUserRequest request, RequestOptions options) throws IOException {
        return this.restHighLevelClient.performRequest(request, SecurityRequestConverters::disableUser, options, RestHighLevelClient::convertExistsResponse, Collections.emptySet());
    }

    @Deprecated
    public boolean disableUser(RequestOptions options, DisableUserRequest request) throws IOException {
        return this.disableUser(request, options);
    }

    public Cancellable disableUserAsync(DisableUserRequest request, RequestOptions options, ActionListener<Boolean> listener) {
        return this.restHighLevelClient.performRequestAsync(request, SecurityRequestConverters::disableUser, options, RestHighLevelClient::convertExistsResponse, listener, Collections.emptySet());
    }

    @Deprecated
    public Cancellable disableUserAsync(RequestOptions options, DisableUserRequest request, ActionListener<Boolean> listener) {
        return this.disableUserAsync(request, options, listener);
    }

    public AuthenticateResponse authenticate(RequestOptions options) throws IOException {
        return this.restHighLevelClient.performRequestAndParseEntity(AuthenticateRequest.INSTANCE, AuthenticateRequest::getRequest, options, AuthenticateResponse::fromXContent, Collections.emptySet());
    }

    public Cancellable authenticateAsync(RequestOptions options, ActionListener<AuthenticateResponse> listener) {
        return this.restHighLevelClient.performRequestAsyncAndParseEntity(AuthenticateRequest.INSTANCE, AuthenticateRequest::getRequest, options, AuthenticateResponse::fromXContent, listener, Collections.emptySet());
    }

    public HasPrivilegesResponse hasPrivileges(HasPrivilegesRequest request, RequestOptions options) throws IOException {
        return this.restHighLevelClient.performRequestAndParseEntity(request, SecurityRequestConverters::hasPrivileges, options, HasPrivilegesResponse::fromXContent, Collections.emptySet());
    }

    public Cancellable hasPrivilegesAsync(HasPrivilegesRequest request, RequestOptions options, ActionListener<HasPrivilegesResponse> listener) {
        return this.restHighLevelClient.performRequestAsyncAndParseEntity(request, SecurityRequestConverters::hasPrivileges, options, HasPrivilegesResponse::fromXContent, listener, Collections.emptySet());
    }

    public GetUserPrivilegesResponse getUserPrivileges(RequestOptions options) throws IOException {
        return this.restHighLevelClient.performRequestAndParseEntity(GetUserPrivilegesRequest.INSTANCE, GetUserPrivilegesRequest::getRequest, options, GetUserPrivilegesResponse::fromXContent, Collections.emptySet());
    }

    public Cancellable getUserPrivilegesAsync(RequestOptions options, ActionListener<GetUserPrivilegesResponse> listener) {
        return this.restHighLevelClient.performRequestAsyncAndParseEntity(GetUserPrivilegesRequest.INSTANCE, GetUserPrivilegesRequest::getRequest, options, GetUserPrivilegesResponse::fromXContent, listener, Collections.emptySet());
    }

    public ClearRealmCacheResponse clearRealmCache(ClearRealmCacheRequest request, RequestOptions options) throws IOException {
        return this.restHighLevelClient.performRequestAndParseEntity(request, SecurityRequestConverters::clearRealmCache, options, ClearRealmCacheResponse::fromXContent, Collections.emptySet());
    }

    public Cancellable clearRealmCacheAsync(ClearRealmCacheRequest request, RequestOptions options, ActionListener<ClearRealmCacheResponse> listener) {
        return this.restHighLevelClient.performRequestAsyncAndParseEntity(request, SecurityRequestConverters::clearRealmCache, options, ClearRealmCacheResponse::fromXContent, listener, Collections.emptySet());
    }

    public ClearRolesCacheResponse clearRolesCache(ClearRolesCacheRequest request, RequestOptions options) throws IOException {
        return this.restHighLevelClient.performRequestAndParseEntity(request, SecurityRequestConverters::clearRolesCache, options, ClearRolesCacheResponse::fromXContent, Collections.emptySet());
    }

    public Cancellable clearRolesCacheAsync(ClearRolesCacheRequest request, RequestOptions options, ActionListener<ClearRolesCacheResponse> listener) {
        return this.restHighLevelClient.performRequestAsyncAndParseEntity(request, SecurityRequestConverters::clearRolesCache, options, ClearRolesCacheResponse::fromXContent, listener, Collections.emptySet());
    }

    public GetSslCertificatesResponse getSslCertificates(RequestOptions options) throws IOException {
        return this.restHighLevelClient.performRequestAndParseEntity(GetSslCertificatesRequest.INSTANCE, GetSslCertificatesRequest::getRequest, options, GetSslCertificatesResponse::fromXContent, Collections.emptySet());
    }

    public Cancellable getSslCertificatesAsync(RequestOptions options, ActionListener<GetSslCertificatesResponse> listener) {
        return this.restHighLevelClient.performRequestAsyncAndParseEntity(GetSslCertificatesRequest.INSTANCE, GetSslCertificatesRequest::getRequest, options, GetSslCertificatesResponse::fromXContent, listener, Collections.emptySet());
    }

    public boolean changePassword(ChangePasswordRequest request, RequestOptions options) throws IOException {
        return this.restHighLevelClient.performRequest(request, SecurityRequestConverters::changePassword, options, RestHighLevelClient::convertExistsResponse, Collections.emptySet());
    }

    @Deprecated
    public boolean changePassword(RequestOptions options, ChangePasswordRequest request) throws IOException {
        return this.changePassword(request, options);
    }

    public Cancellable changePasswordAsync(ChangePasswordRequest request, RequestOptions options, ActionListener<Boolean> listener) {
        return this.restHighLevelClient.performRequestAsync(request, SecurityRequestConverters::changePassword, options, RestHighLevelClient::convertExistsResponse, listener, Collections.emptySet());
    }

    @Deprecated
    public Cancellable changePasswordAsync(RequestOptions options, ChangePasswordRequest request, ActionListener<Boolean> listener) {
        return this.changePasswordAsync(request, options, listener);
    }

    public DeleteRoleMappingResponse deleteRoleMapping(DeleteRoleMappingRequest request, RequestOptions options) throws IOException {
        return this.restHighLevelClient.performRequestAndParseEntity(request, SecurityRequestConverters::deleteRoleMapping, options, DeleteRoleMappingResponse::fromXContent, Collections.emptySet());
    }

    public Cancellable getRolesAsync(GetRolesRequest request, RequestOptions options, ActionListener<GetRolesResponse> listener) {
        return this.restHighLevelClient.performRequestAsyncAndParseEntity(request, SecurityRequestConverters::getRoles, options, GetRolesResponse::fromXContent, listener, Collections.emptySet());
    }

    public GetRolesResponse getRoles(GetRolesRequest request, RequestOptions options) throws IOException {
        return this.restHighLevelClient.performRequestAndParseEntity(request, SecurityRequestConverters::getRoles, options, GetRolesResponse::fromXContent, Collections.emptySet());
    }

    public Cancellable putRoleAsync(PutRoleRequest request, RequestOptions options, ActionListener<PutRoleResponse> listener) {
        return this.restHighLevelClient.performRequestAsyncAndParseEntity(request, SecurityRequestConverters::putRole, options, PutRoleResponse::fromXContent, listener, Collections.emptySet());
    }

    public PutRoleResponse putRole(PutRoleRequest request, RequestOptions options) throws IOException {
        return this.restHighLevelClient.performRequestAndParseEntity(request, SecurityRequestConverters::putRole, options, PutRoleResponse::fromXContent, Collections.emptySet());
    }

    public Cancellable deleteRoleMappingAsync(DeleteRoleMappingRequest request, RequestOptions options, ActionListener<DeleteRoleMappingResponse> listener) {
        return this.restHighLevelClient.performRequestAsyncAndParseEntity(request, SecurityRequestConverters::deleteRoleMapping, options, DeleteRoleMappingResponse::fromXContent, listener, Collections.emptySet());
    }

    public DeleteRoleResponse deleteRole(DeleteRoleRequest request, RequestOptions options) throws IOException {
        return this.restHighLevelClient.performRequestAndParseEntity(request, SecurityRequestConverters::deleteRole, options, DeleteRoleResponse::fromXContent, Collections.singleton(404));
    }

    public Cancellable deleteRoleAsync(DeleteRoleRequest request, RequestOptions options, ActionListener<DeleteRoleResponse> listener) {
        return this.restHighLevelClient.performRequestAsyncAndParseEntity(request, SecurityRequestConverters::deleteRole, options, DeleteRoleResponse::fromXContent, listener, Collections.singleton(404));
    }

    public CreateTokenResponse createToken(CreateTokenRequest request, RequestOptions options) throws IOException {
        return this.restHighLevelClient.performRequestAndParseEntity(request, SecurityRequestConverters::createToken, options, CreateTokenResponse::fromXContent, Collections.emptySet());
    }

    public Cancellable createTokenAsync(CreateTokenRequest request, RequestOptions options, ActionListener<CreateTokenResponse> listener) {
        return this.restHighLevelClient.performRequestAsyncAndParseEntity(request, SecurityRequestConverters::createToken, options, CreateTokenResponse::fromXContent, listener, Collections.emptySet());
    }

    public InvalidateTokenResponse invalidateToken(InvalidateTokenRequest request, RequestOptions options) throws IOException {
        return this.restHighLevelClient.performRequestAndParseEntity(request, SecurityRequestConverters::invalidateToken, options, InvalidateTokenResponse::fromXContent, Collections.emptySet());
    }

    public Cancellable invalidateTokenAsync(InvalidateTokenRequest request, RequestOptions options, ActionListener<InvalidateTokenResponse> listener) {
        return this.restHighLevelClient.performRequestAsyncAndParseEntity(request, SecurityRequestConverters::invalidateToken, options, InvalidateTokenResponse::fromXContent, listener, Collections.emptySet());
    }

    public GetBuiltinPrivilegesResponse getBuiltinPrivileges(RequestOptions options) throws IOException {
        return this.restHighLevelClient.performRequestAndParseEntity(GetBuiltinPrivilegesRequest.INSTANCE, GetBuiltinPrivilegesRequest::getRequest, options, GetBuiltinPrivilegesResponse::fromXContent, Collections.emptySet());
    }

    public Cancellable getBuiltinPrivilegesAsync(RequestOptions options, ActionListener<GetBuiltinPrivilegesResponse> listener) {
        return this.restHighLevelClient.performRequestAsyncAndParseEntity(GetBuiltinPrivilegesRequest.INSTANCE, GetBuiltinPrivilegesRequest::getRequest, options, GetBuiltinPrivilegesResponse::fromXContent, listener, Collections.emptySet());
    }

    public GetPrivilegesResponse getPrivileges(GetPrivilegesRequest request, RequestOptions options) throws IOException {
        return this.restHighLevelClient.performRequestAndParseEntity(request, SecurityRequestConverters::getPrivileges, options, GetPrivilegesResponse::fromXContent, Collections.emptySet());
    }

    public Cancellable getPrivilegesAsync(GetPrivilegesRequest request, RequestOptions options, ActionListener<GetPrivilegesResponse> listener) {
        return this.restHighLevelClient.performRequestAsyncAndParseEntity(request, SecurityRequestConverters::getPrivileges, options, GetPrivilegesResponse::fromXContent, listener, Collections.emptySet());
    }

    public PutPrivilegesResponse putPrivileges(PutPrivilegesRequest request, RequestOptions options) throws IOException {
        return this.restHighLevelClient.performRequestAndParseEntity(request, SecurityRequestConverters::putPrivileges, options, PutPrivilegesResponse::fromXContent, Collections.emptySet());
    }

    public Cancellable putPrivilegesAsync(PutPrivilegesRequest request, RequestOptions options, ActionListener<PutPrivilegesResponse> listener) {
        return this.restHighLevelClient.performRequestAsyncAndParseEntity(request, SecurityRequestConverters::putPrivileges, options, PutPrivilegesResponse::fromXContent, listener, Collections.emptySet());
    }

    public DeletePrivilegesResponse deletePrivileges(DeletePrivilegesRequest request, RequestOptions options) throws IOException {
        return this.restHighLevelClient.performRequestAndParseEntity(request, SecurityRequestConverters::deletePrivileges, options, DeletePrivilegesResponse::fromXContent, Collections.singleton(404));
    }

    public Cancellable deletePrivilegesAsync(DeletePrivilegesRequest request, RequestOptions options, ActionListener<DeletePrivilegesResponse> listener) {
        return this.restHighLevelClient.performRequestAsyncAndParseEntity(request, SecurityRequestConverters::deletePrivileges, options, DeletePrivilegesResponse::fromXContent, listener, Collections.singleton(404));
    }

    public CreateApiKeyResponse createApiKey(CreateApiKeyRequest request, RequestOptions options) throws IOException {
        return this.restHighLevelClient.performRequestAndParseEntity(request, SecurityRequestConverters::createApiKey, options, CreateApiKeyResponse::fromXContent, Collections.emptySet());
    }

    public Cancellable createApiKeyAsync(CreateApiKeyRequest request, RequestOptions options, ActionListener<CreateApiKeyResponse> listener) {
        return this.restHighLevelClient.performRequestAsyncAndParseEntity(request, SecurityRequestConverters::createApiKey, options, CreateApiKeyResponse::fromXContent, listener, Collections.emptySet());
    }

    public GetApiKeyResponse getApiKey(GetApiKeyRequest request, RequestOptions options) throws IOException {
        return this.restHighLevelClient.performRequestAndParseEntity(request, SecurityRequestConverters::getApiKey, options, GetApiKeyResponse::fromXContent, Collections.emptySet());
    }

    public Cancellable getApiKeyAsync(GetApiKeyRequest request, RequestOptions options, ActionListener<GetApiKeyResponse> listener) {
        return this.restHighLevelClient.performRequestAsyncAndParseEntity(request, SecurityRequestConverters::getApiKey, options, GetApiKeyResponse::fromXContent, listener, Collections.emptySet());
    }

    public InvalidateApiKeyResponse invalidateApiKey(InvalidateApiKeyRequest request, RequestOptions options) throws IOException {
        return this.restHighLevelClient.performRequestAndParseEntity(request, SecurityRequestConverters::invalidateApiKey, options, InvalidateApiKeyResponse::fromXContent, Collections.emptySet());
    }

    public Cancellable invalidateApiKeyAsync(InvalidateApiKeyRequest request, RequestOptions options, ActionListener<InvalidateApiKeyResponse> listener) {
        return this.restHighLevelClient.performRequestAsyncAndParseEntity(request, SecurityRequestConverters::invalidateApiKey, options, InvalidateApiKeyResponse::fromXContent, listener, Collections.emptySet());
    }

    public DelegatePkiAuthenticationResponse delegatePkiAuthentication(DelegatePkiAuthenticationRequest request, RequestOptions options) throws IOException {
        return this.restHighLevelClient.performRequestAndParseEntity(request, SecurityRequestConverters::delegatePkiAuthentication, options, DelegatePkiAuthenticationResponse::fromXContent, Collections.emptySet());
    }

    public Cancellable delegatePkiAuthenticationAsync(DelegatePkiAuthenticationRequest request, RequestOptions options, ActionListener<DelegatePkiAuthenticationResponse> listener) {
        return this.restHighLevelClient.performRequestAsyncAndParseEntity(request, SecurityRequestConverters::delegatePkiAuthentication, options, DelegatePkiAuthenticationResponse::fromXContent, listener, Collections.emptySet());
    }
}

