/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client;

import java.io.IOException;
import java.util.Collections;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.ActionListener;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.Cancellable;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.CcrRequestConverters;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.RequestOptions;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.RestHighLevelClient;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.ccr.CcrStatsRequest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.ccr.CcrStatsResponse;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.ccr.DeleteAutoFollowPatternRequest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.ccr.FollowInfoRequest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.ccr.FollowInfoResponse;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.ccr.FollowStatsRequest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.ccr.FollowStatsResponse;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.ccr.ForgetFollowerRequest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.ccr.GetAutoFollowPatternRequest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.ccr.GetAutoFollowPatternResponse;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.ccr.PauseAutoFollowPatternRequest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.ccr.PauseFollowRequest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.ccr.PutAutoFollowPatternRequest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.ccr.PutFollowRequest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.ccr.PutFollowResponse;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.ccr.ResumeAutoFollowPatternRequest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.ccr.ResumeFollowRequest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.ccr.UnfollowRequest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.core.AcknowledgedResponse;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.core.BroadcastResponse;

public final class CcrClient {
    private final RestHighLevelClient restHighLevelClient;

    CcrClient(RestHighLevelClient restHighLevelClient) {
        this.restHighLevelClient = restHighLevelClient;
    }

    public PutFollowResponse putFollow(PutFollowRequest request, RequestOptions options) throws IOException {
        return this.restHighLevelClient.performRequestAndParseEntity(request, CcrRequestConverters::putFollow, options, PutFollowResponse::fromXContent, Collections.emptySet());
    }

    public Cancellable putFollowAsync(PutFollowRequest request, RequestOptions options, ActionListener<PutFollowResponse> listener) {
        return this.restHighLevelClient.performRequestAsyncAndParseEntity(request, CcrRequestConverters::putFollow, options, PutFollowResponse::fromXContent, listener, Collections.emptySet());
    }

    public AcknowledgedResponse pauseFollow(PauseFollowRequest request, RequestOptions options) throws IOException {
        return this.restHighLevelClient.performRequestAndParseEntity(request, CcrRequestConverters::pauseFollow, options, AcknowledgedResponse::fromXContent, Collections.emptySet());
    }

    public Cancellable pauseFollowAsync(PauseFollowRequest request, RequestOptions options, ActionListener<AcknowledgedResponse> listener) {
        return this.restHighLevelClient.performRequestAsyncAndParseEntity(request, CcrRequestConverters::pauseFollow, options, AcknowledgedResponse::fromXContent, listener, Collections.emptySet());
    }

    public AcknowledgedResponse resumeFollow(ResumeFollowRequest request, RequestOptions options) throws IOException {
        return this.restHighLevelClient.performRequestAndParseEntity(request, CcrRequestConverters::resumeFollow, options, AcknowledgedResponse::fromXContent, Collections.emptySet());
    }

    public Cancellable resumeFollowAsync(ResumeFollowRequest request, RequestOptions options, ActionListener<AcknowledgedResponse> listener) {
        return this.restHighLevelClient.performRequestAsyncAndParseEntity(request, CcrRequestConverters::resumeFollow, options, AcknowledgedResponse::fromXContent, listener, Collections.emptySet());
    }

    public AcknowledgedResponse unfollow(UnfollowRequest request, RequestOptions options) throws IOException {
        return this.restHighLevelClient.performRequestAndParseEntity(request, CcrRequestConverters::unfollow, options, AcknowledgedResponse::fromXContent, Collections.emptySet());
    }

    public Cancellable unfollowAsync(UnfollowRequest request, RequestOptions options, ActionListener<AcknowledgedResponse> listener) {
        return this.restHighLevelClient.performRequestAsyncAndParseEntity(request, CcrRequestConverters::unfollow, options, AcknowledgedResponse::fromXContent, listener, Collections.emptySet());
    }

    public BroadcastResponse forgetFollower(ForgetFollowerRequest request, RequestOptions options) throws IOException {
        return this.restHighLevelClient.performRequestAndParseEntity(request, CcrRequestConverters::forgetFollower, options, BroadcastResponse::fromXContent, Collections.emptySet());
    }

    public Cancellable forgetFollowerAsync(ForgetFollowerRequest request, RequestOptions options, ActionListener<BroadcastResponse> listener) {
        return this.restHighLevelClient.performRequestAsyncAndParseEntity(request, CcrRequestConverters::forgetFollower, options, BroadcastResponse::fromXContent, listener, Collections.emptySet());
    }

    public AcknowledgedResponse putAutoFollowPattern(PutAutoFollowPatternRequest request, RequestOptions options) throws IOException {
        return this.restHighLevelClient.performRequestAndParseEntity(request, CcrRequestConverters::putAutoFollowPattern, options, AcknowledgedResponse::fromXContent, Collections.emptySet());
    }

    public Cancellable putAutoFollowPatternAsync(PutAutoFollowPatternRequest request, RequestOptions options, ActionListener<AcknowledgedResponse> listener) {
        return this.restHighLevelClient.performRequestAsyncAndParseEntity(request, CcrRequestConverters::putAutoFollowPattern, options, AcknowledgedResponse::fromXContent, listener, Collections.emptySet());
    }

    public AcknowledgedResponse deleteAutoFollowPattern(DeleteAutoFollowPatternRequest request, RequestOptions options) throws IOException {
        return this.restHighLevelClient.performRequestAndParseEntity(request, CcrRequestConverters::deleteAutoFollowPattern, options, AcknowledgedResponse::fromXContent, Collections.emptySet());
    }

    public Cancellable deleteAutoFollowPatternAsync(DeleteAutoFollowPatternRequest request, RequestOptions options, ActionListener<AcknowledgedResponse> listener) {
        return this.restHighLevelClient.performRequestAsyncAndParseEntity(request, CcrRequestConverters::deleteAutoFollowPattern, options, AcknowledgedResponse::fromXContent, listener, Collections.emptySet());
    }

    public GetAutoFollowPatternResponse getAutoFollowPattern(GetAutoFollowPatternRequest request, RequestOptions options) throws IOException {
        return this.restHighLevelClient.performRequestAndParseEntity(request, CcrRequestConverters::getAutoFollowPattern, options, GetAutoFollowPatternResponse::fromXContent, Collections.emptySet());
    }

    public Cancellable getAutoFollowPatternAsync(GetAutoFollowPatternRequest request, RequestOptions options, ActionListener<GetAutoFollowPatternResponse> listener) {
        return this.restHighLevelClient.performRequestAsyncAndParseEntity(request, CcrRequestConverters::getAutoFollowPattern, options, GetAutoFollowPatternResponse::fromXContent, listener, Collections.emptySet());
    }

    public AcknowledgedResponse pauseAutoFollowPattern(PauseAutoFollowPatternRequest request, RequestOptions options) throws IOException {
        return this.restHighLevelClient.performRequestAndParseEntity(request, CcrRequestConverters::pauseAutoFollowPattern, options, AcknowledgedResponse::fromXContent, Collections.emptySet());
    }

    public Cancellable pauseAutoFollowPatternAsync(PauseAutoFollowPatternRequest request, RequestOptions options, ActionListener<AcknowledgedResponse> listener) {
        return this.restHighLevelClient.performRequestAsyncAndParseEntity(request, CcrRequestConverters::pauseAutoFollowPattern, options, AcknowledgedResponse::fromXContent, listener, Collections.emptySet());
    }

    public AcknowledgedResponse resumeAutoFollowPattern(ResumeAutoFollowPatternRequest request, RequestOptions options) throws IOException {
        return this.restHighLevelClient.performRequestAndParseEntity(request, CcrRequestConverters::resumeAutoFollowPattern, options, AcknowledgedResponse::fromXContent, Collections.emptySet());
    }

    public Cancellable resumeAutoFollowPatternAsync(ResumeAutoFollowPatternRequest request, RequestOptions options, ActionListener<AcknowledgedResponse> listener) {
        return this.restHighLevelClient.performRequestAsyncAndParseEntity(request, CcrRequestConverters::resumeAutoFollowPattern, options, AcknowledgedResponse::fromXContent, listener, Collections.emptySet());
    }

    public CcrStatsResponse getCcrStats(CcrStatsRequest request, RequestOptions options) throws IOException {
        return this.restHighLevelClient.performRequestAndParseEntity(request, CcrRequestConverters::getCcrStats, options, CcrStatsResponse::fromXContent, Collections.emptySet());
    }

    public Cancellable getCcrStatsAsync(CcrStatsRequest request, RequestOptions options, ActionListener<CcrStatsResponse> listener) {
        return this.restHighLevelClient.performRequestAsyncAndParseEntity(request, CcrRequestConverters::getCcrStats, options, CcrStatsResponse::fromXContent, listener, Collections.emptySet());
    }

    public FollowStatsResponse getFollowStats(FollowStatsRequest request, RequestOptions options) throws IOException {
        return this.restHighLevelClient.performRequestAndParseEntity(request, CcrRequestConverters::getFollowStats, options, FollowStatsResponse::fromXContent, Collections.emptySet());
    }

    public Cancellable getFollowStatsAsync(FollowStatsRequest request, RequestOptions options, ActionListener<FollowStatsResponse> listener) {
        return this.restHighLevelClient.performRequestAsyncAndParseEntity(request, CcrRequestConverters::getFollowStats, options, FollowStatsResponse::fromXContent, listener, Collections.emptySet());
    }

    public FollowInfoResponse getFollowInfo(FollowInfoRequest request, RequestOptions options) throws IOException {
        return this.restHighLevelClient.performRequestAndParseEntity(request, CcrRequestConverters::getFollowInfo, options, FollowInfoResponse::fromXContent, Collections.emptySet());
    }

    public Cancellable getFollowInfoAsync(FollowInfoRequest request, RequestOptions options, ActionListener<FollowInfoResponse> listener) {
        return this.restHighLevelClient.performRequestAsyncAndParseEntity(request, CcrRequestConverters::getFollowInfo, options, FollowInfoResponse::fromXContent, listener, Collections.emptySet());
    }
}

