/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.admin.indices.recovery;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.support.DefaultShardOperationFailedException;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.support.broadcast.BroadcastResponse;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.Strings;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.io.stream.StreamInput;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.io.stream.StreamOutput;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ToXContent;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentBuilder;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.indices.recovery.RecoveryState;

public class RecoveryResponse
extends BroadcastResponse {
    private Map<String, List<RecoveryState>> shardRecoveryStates = new HashMap<String, List<RecoveryState>>();

    public RecoveryResponse(StreamInput in) throws IOException {
        super(in);
        int size = in.readVInt();
        for (int i = 0; i < size; ++i) {
            String s = in.readString();
            int listSize = in.readVInt();
            ArrayList<RecoveryState> list = new ArrayList<RecoveryState>(listSize);
            for (int j = 0; j < listSize; ++j) {
                list.add(RecoveryState.readRecoveryState(in));
            }
            this.shardRecoveryStates.put(s, list);
        }
    }

    public RecoveryResponse(int totalShards, int successfulShards, int failedShards, Map<String, List<RecoveryState>> shardRecoveryStates, List<DefaultShardOperationFailedException> shardFailures) {
        super(totalShards, successfulShards, failedShards, shardFailures);
        this.shardRecoveryStates = shardRecoveryStates;
    }

    public boolean hasRecoveries() {
        return this.shardRecoveryStates.size() > 0;
    }

    public Map<String, List<RecoveryState>> shardRecoveryStates() {
        return this.shardRecoveryStates;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.hasRecoveries()) {
            for (String index : this.shardRecoveryStates.keySet()) {
                List<RecoveryState> recoveryStates = this.shardRecoveryStates.get(index);
                if (recoveryStates == null || recoveryStates.size() == 0) continue;
                builder.startObject(index);
                builder.startArray("shards");
                for (RecoveryState recoveryState : recoveryStates) {
                    builder.startObject();
                    recoveryState.toXContent(builder, params);
                    builder.endObject();
                }
                builder.endArray();
                builder.endObject();
            }
        }
        builder.endObject();
        return builder;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeVInt(this.shardRecoveryStates.size());
        for (Map.Entry<String, List<RecoveryState>> entry : this.shardRecoveryStates.entrySet()) {
            out.writeString(entry.getKey());
            out.writeVInt(entry.getValue().size());
            for (RecoveryState recoveryState : entry.getValue()) {
                recoveryState.writeTo(out);
            }
        }
    }

    public String toString() {
        return Strings.toString(this, true, true);
    }
}

