/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.admin.indices.exists.types;

import java.io.IOException;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.ActionRequestValidationException;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.IndicesRequest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.ValidateActions;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.support.IndicesOptions;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.support.master.MasterNodeReadRequest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.io.stream.StreamInput;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.io.stream.StreamOutput;

public class TypesExistsRequest
extends MasterNodeReadRequest<TypesExistsRequest>
implements IndicesRequest.Replaceable {
    private String[] indices;
    private String[] types;
    private IndicesOptions indicesOptions = IndicesOptions.strictExpandOpen();

    public TypesExistsRequest() {
    }

    public TypesExistsRequest(String[] indices, String ... types) {
        this.indices = indices;
        this.types = types;
    }

    public TypesExistsRequest(StreamInput in) throws IOException {
        super(in);
        this.indices = in.readStringArray();
        this.types = in.readStringArray();
        this.indicesOptions = IndicesOptions.readIndicesOptions(in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeStringArray(this.indices);
        out.writeStringArray(this.types);
        this.indicesOptions.writeIndicesOptions(out);
    }

    @Override
    public String[] indices() {
        return this.indices;
    }

    @Override
    public TypesExistsRequest indices(String ... indices) {
        this.indices = indices;
        return this;
    }

    public String[] types() {
        return this.types;
    }

    public void types(String[] types) {
        this.types = types;
    }

    @Override
    public IndicesOptions indicesOptions() {
        return this.indicesOptions;
    }

    public TypesExistsRequest indicesOptions(IndicesOptions indicesOptions) {
        this.indicesOptions = indicesOptions;
        return this;
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.indices == null) {
            validationException = ValidateActions.addValidationError("index/indices is missing", validationException);
        }
        if (this.types == null || this.types.length == 0) {
            validationException = ValidateActions.addValidationError("type/types is missing", validationException);
        }
        return validationException;
    }
}

