/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.admin.indices.analyze;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.Version;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.ActionRequestValidationException;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.ActionResponse;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.ActionType;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.ValidateActions;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.support.single.shard.SingleShardRequest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.ParseField;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.Strings;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.io.stream.StreamInput;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.io.stream.StreamOutput;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.io.stream.Writeable;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ObjectParser;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ToXContent;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ToXContentFragment;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ToXContentObject;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentBuilder;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentParser;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.analysis.NameOrDefinition;

public class AnalyzeAction
extends ActionType<Response> {
    public static final AnalyzeAction INSTANCE = new AnalyzeAction();
    public static final String NAME = "indices:admin/analyze";

    private AnalyzeAction() {
        super(NAME, Response::new);
    }

    public static class CharFilteredText
    implements Writeable,
    ToXContentObject {
        private final String name;
        private final String[] texts;
        static final String NAME = "name";
        static final String FILTERED_TEXT = "filtered_text";

        public CharFilteredText(String name, String[] texts) {
            this.name = name;
            this.texts = texts != null ? texts : Strings.EMPTY_ARRAY;
        }

        CharFilteredText(StreamInput in) throws IOException {
            this.name = in.readString();
            this.texts = in.readStringArray();
        }

        public String getName() {
            return this.name;
        }

        public String[] getTexts() {
            return this.texts;
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(NAME, this.name);
            builder.array(FILTERED_TEXT, this.texts);
            builder.endObject();
            return builder;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.name);
            out.writeStringArray(this.texts);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CharFilteredText that = (CharFilteredText)o;
            return Objects.equals(this.name, that.name) && Arrays.equals(this.texts, that.texts);
        }

        public int hashCode() {
            int result = Objects.hash(this.name);
            result = 31 * result + Arrays.hashCode(this.texts);
            return result;
        }
    }

    public static class AnalyzeTokenList
    implements Writeable,
    ToXContentObject {
        private final String name;
        private final AnalyzeToken[] tokens;
        static final String NAME = "name";

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AnalyzeTokenList that = (AnalyzeTokenList)o;
            return Objects.equals(this.name, that.name) && Arrays.equals(this.tokens, that.tokens);
        }

        public int hashCode() {
            int result = Objects.hash(this.name);
            result = 31 * result + Arrays.hashCode(this.tokens);
            return result;
        }

        public AnalyzeTokenList(String name, AnalyzeToken[] tokens) {
            this.name = name;
            this.tokens = tokens;
        }

        AnalyzeTokenList(StreamInput in) throws IOException {
            this.name = in.readString();
            if (in.getVersion().onOrAfter(Version.V_7_3_0)) {
                this.tokens = in.readOptionalArray(AnalyzeToken::new, AnalyzeToken[]::new);
            } else {
                int size = in.readVInt();
                if (size > 0) {
                    this.tokens = new AnalyzeToken[size];
                    for (int i = 0; i < size; ++i) {
                        this.tokens[i] = new AnalyzeToken(in);
                    }
                } else {
                    this.tokens = null;
                }
            }
        }

        public String getName() {
            return this.name;
        }

        public AnalyzeToken[] getTokens() {
            return this.tokens;
        }

        void toXContentWithoutObject(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.field(NAME, this.name);
            builder.startArray("tokens");
            if (this.tokens != null) {
                for (AnalyzeToken token : this.tokens) {
                    token.toXContent(builder, params);
                }
            }
            builder.endArray();
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            this.toXContentWithoutObject(builder, params);
            builder.endObject();
            return builder;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.name);
            if (out.getVersion().onOrAfter(Version.V_7_3_0)) {
                out.writeOptionalArray(this.tokens);
            } else if (this.tokens != null) {
                out.writeVInt(this.tokens.length);
                for (AnalyzeToken token : this.tokens) {
                    token.writeTo(out);
                }
            } else {
                out.writeVInt(0);
            }
        }
    }

    public static class DetailAnalyzeResponse
    implements Writeable,
    ToXContentFragment {
        private final boolean customAnalyzer;
        private final AnalyzeTokenList analyzer;
        private final CharFilteredText[] charfilters;
        private final AnalyzeTokenList tokenizer;
        private final AnalyzeTokenList[] tokenfilters;

        public DetailAnalyzeResponse(AnalyzeTokenList analyzer) {
            this(false, analyzer, null, null, null);
        }

        public DetailAnalyzeResponse(CharFilteredText[] charfilters, AnalyzeTokenList tokenizer, AnalyzeTokenList[] tokenfilters) {
            this(true, null, charfilters, tokenizer, tokenfilters);
        }

        DetailAnalyzeResponse(boolean customAnalyzer, AnalyzeTokenList analyzer, CharFilteredText[] charfilters, AnalyzeTokenList tokenizer, AnalyzeTokenList[] tokenfilters) {
            this.customAnalyzer = customAnalyzer;
            this.analyzer = analyzer;
            this.charfilters = charfilters;
            this.tokenizer = tokenizer;
            this.tokenfilters = tokenfilters;
        }

        DetailAnalyzeResponse(StreamInput in) throws IOException {
            this.customAnalyzer = in.readBoolean();
            if (this.customAnalyzer) {
                int i;
                this.tokenizer = new AnalyzeTokenList(in);
                int size = in.readVInt();
                if (size > 0) {
                    this.charfilters = new CharFilteredText[size];
                    for (i = 0; i < size; ++i) {
                        this.charfilters[i] = new CharFilteredText(in);
                    }
                } else {
                    this.charfilters = null;
                }
                if ((size = in.readVInt()) > 0) {
                    this.tokenfilters = new AnalyzeTokenList[size];
                    for (i = 0; i < size; ++i) {
                        this.tokenfilters[i] = new AnalyzeTokenList(in);
                    }
                } else {
                    this.tokenfilters = null;
                }
                this.analyzer = null;
            } else {
                this.analyzer = new AnalyzeTokenList(in);
                this.tokenfilters = null;
                this.tokenizer = null;
                this.charfilters = null;
            }
        }

        public AnalyzeTokenList analyzer() {
            return this.analyzer;
        }

        public CharFilteredText[] charfilters() {
            return this.charfilters;
        }

        public AnalyzeTokenList tokenizer() {
            return this.tokenizer;
        }

        public AnalyzeTokenList[] tokenfilters() {
            return this.tokenfilters;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DetailAnalyzeResponse that = (DetailAnalyzeResponse)o;
            return this.customAnalyzer == that.customAnalyzer && Objects.equals(this.analyzer, that.analyzer) && Arrays.equals(this.charfilters, that.charfilters) && Objects.equals(this.tokenizer, that.tokenizer) && Arrays.equals(this.tokenfilters, that.tokenfilters);
        }

        public int hashCode() {
            int result = Objects.hash(this.customAnalyzer, this.analyzer, this.tokenizer);
            result = 31 * result + Arrays.hashCode(this.charfilters);
            result = 31 * result + Arrays.hashCode(this.tokenfilters);
            return result;
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.field("custom_analyzer", this.customAnalyzer);
            if (this.analyzer != null) {
                builder.startObject("analyzer");
                this.analyzer.toXContentWithoutObject(builder, params);
                builder.endObject();
            }
            if (this.charfilters != null) {
                builder.startArray("charfilters");
                for (Writeable writeable : this.charfilters) {
                    ((CharFilteredText)writeable).toXContent(builder, params);
                }
                builder.endArray();
            }
            if (this.tokenizer != null) {
                builder.startObject("tokenizer");
                this.tokenizer.toXContentWithoutObject(builder, params);
                builder.endObject();
            }
            if (this.tokenfilters != null) {
                builder.startArray("tokenfilters");
                for (Writeable writeable : this.tokenfilters) {
                    ((AnalyzeTokenList)writeable).toXContent(builder, params);
                }
                builder.endArray();
            }
            return builder;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeBoolean(this.customAnalyzer);
            if (this.customAnalyzer) {
                this.tokenizer.writeTo(out);
                if (this.charfilters != null) {
                    out.writeVInt(this.charfilters.length);
                    for (Writeable writeable : this.charfilters) {
                        ((CharFilteredText)writeable).writeTo(out);
                    }
                } else {
                    out.writeVInt(0);
                }
                if (this.tokenfilters != null) {
                    out.writeVInt(this.tokenfilters.length);
                    for (Writeable writeable : this.tokenfilters) {
                        ((AnalyzeTokenList)writeable).writeTo(out);
                    }
                } else {
                    out.writeVInt(0);
                }
            } else {
                this.analyzer.writeTo(out);
            }
        }
    }

    public static class AnalyzeToken
    implements Writeable,
    ToXContentObject {
        private final String term;
        private final int startOffset;
        private final int endOffset;
        private final int position;
        private final int positionLength;
        private final Map<String, Object> attributes;
        private final String type;
        static final String TOKEN = "token";
        static final String START_OFFSET = "start_offset";
        static final String END_OFFSET = "end_offset";
        static final String TYPE = "type";
        static final String POSITION = "position";
        static final String POSITION_LENGTH = "positionLength";

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AnalyzeToken that = (AnalyzeToken)o;
            return this.startOffset == that.startOffset && this.endOffset == that.endOffset && this.position == that.position && this.positionLength == that.positionLength && Objects.equals(this.term, that.term) && Objects.equals(this.attributes, that.attributes) && Objects.equals(this.type, that.type);
        }

        public int hashCode() {
            return Objects.hash(this.term, this.startOffset, this.endOffset, this.position, this.positionLength, this.attributes, this.type);
        }

        public AnalyzeToken(String term, int position, int startOffset, int endOffset, int positionLength, String type, Map<String, Object> attributes) {
            this.term = term;
            this.position = position;
            this.startOffset = startOffset;
            this.endOffset = endOffset;
            this.positionLength = positionLength;
            this.type = type;
            this.attributes = attributes;
        }

        AnalyzeToken(StreamInput in) throws IOException {
            this.term = in.readString();
            this.startOffset = in.readInt();
            this.endOffset = in.readInt();
            this.position = in.readVInt();
            Integer len = in.readOptionalVInt();
            this.positionLength = len != null ? len : 1;
            this.type = in.readOptionalString();
            this.attributes = in.readMap();
        }

        public String getTerm() {
            return this.term;
        }

        public int getStartOffset() {
            return this.startOffset;
        }

        public int getEndOffset() {
            return this.endOffset;
        }

        public int getPosition() {
            return this.position;
        }

        public int getPositionLength() {
            return this.positionLength;
        }

        public String getType() {
            return this.type;
        }

        public Map<String, Object> getAttributes() {
            return this.attributes;
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(TOKEN, this.term);
            builder.field(START_OFFSET, this.startOffset);
            builder.field(END_OFFSET, this.endOffset);
            builder.field(TYPE, this.type);
            builder.field(POSITION, this.position);
            if (this.positionLength > 1) {
                builder.field(POSITION_LENGTH, this.positionLength);
            }
            if (this.attributes != null && !this.attributes.isEmpty()) {
                TreeMap<String, Object> sortedAttributes = new TreeMap<String, Object>(this.attributes);
                for (Map.Entry entity : sortedAttributes.entrySet()) {
                    builder.field((String)entity.getKey(), entity.getValue());
                }
            }
            builder.endObject();
            return builder;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.term);
            out.writeInt(this.startOffset);
            out.writeInt(this.endOffset);
            out.writeVInt(this.position);
            out.writeOptionalVInt(this.positionLength > 1 ? Integer.valueOf(this.positionLength) : null);
            out.writeOptionalString(this.type);
            out.writeMapWithConsistentOrder(this.attributes);
        }
    }

    public static class Response
    extends ActionResponse
    implements ToXContentObject {
        private final DetailAnalyzeResponse detail;
        private final List<AnalyzeToken> tokens;

        public Response(List<AnalyzeToken> tokens, DetailAnalyzeResponse detail) {
            if (tokens == null && detail == null) {
                throw new IllegalArgumentException("Neither token nor detail set on AnalysisAction.Response");
            }
            this.tokens = tokens;
            this.detail = detail;
        }

        public Response(StreamInput in) throws IOException {
            if (in.getVersion().onOrAfter(Version.V_7_3_0)) {
                AnalyzeToken[] tokenArray = in.readOptionalArray(AnalyzeToken::new, AnalyzeToken[]::new);
                this.tokens = tokenArray != null ? Arrays.asList(tokenArray) : null;
            } else {
                int size = in.readVInt();
                if (size > 0) {
                    this.tokens = new ArrayList<AnalyzeToken>(size);
                    for (int i = 0; i < size; ++i) {
                        this.tokens.add(new AnalyzeToken(in));
                    }
                } else {
                    this.tokens = null;
                }
            }
            this.detail = in.readOptionalWriteable(DetailAnalyzeResponse::new);
        }

        public List<AnalyzeToken> getTokens() {
            return this.tokens;
        }

        public DetailAnalyzeResponse detail() {
            return this.detail;
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            if (this.tokens != null) {
                builder.startArray("tokens");
                for (AnalyzeToken token : this.tokens) {
                    token.toXContent(builder, params);
                }
                builder.endArray();
            }
            if (this.detail != null) {
                builder.startObject("detail");
                this.detail.toXContent(builder, params);
                builder.endObject();
            }
            builder.endObject();
            return builder;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            if (out.getVersion().onOrAfter(Version.V_7_3_0)) {
                AnalyzeToken[] tokenArray = null;
                if (this.tokens != null) {
                    tokenArray = this.tokens.toArray(new AnalyzeToken[0]);
                }
                out.writeOptionalArray(tokenArray);
            } else if (this.tokens != null) {
                out.writeVInt(this.tokens.size());
                for (AnalyzeToken token : this.tokens) {
                    token.writeTo(out);
                }
            } else {
                out.writeVInt(0);
            }
            out.writeOptionalWriteable(this.detail);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Response that = (Response)o;
            return Objects.equals(this.detail, that.detail) && Objects.equals(this.tokens, that.tokens);
        }

        public int hashCode() {
            return Objects.hash(this.detail, this.tokens);
        }

        public String toString() {
            return Strings.toString(this, true, true);
        }

        static final class Fields {
            static final String TOKENS = "tokens";
            static final String DETAIL = "detail";

            Fields() {
            }
        }
    }

    public static class Request
    extends SingleShardRequest<Request> {
        private String[] text;
        private String analyzer;
        private NameOrDefinition tokenizer;
        private final List<NameOrDefinition> tokenFilters = new ArrayList<NameOrDefinition>();
        private final List<NameOrDefinition> charFilters = new ArrayList<NameOrDefinition>();
        private String field;
        private boolean explain = false;
        private String[] attributes = Strings.EMPTY_ARRAY;
        private String normalizer;
        private static final ObjectParser<Request, Void> PARSER = new ObjectParser("analyze_request", null);

        public Request() {
        }

        Request(StreamInput in) throws IOException {
            super(in);
            this.text = in.readStringArray();
            this.analyzer = in.readOptionalString();
            this.tokenizer = in.readOptionalWriteable(NameOrDefinition::new);
            this.tokenFilters.addAll(in.readList(NameOrDefinition::new));
            this.charFilters.addAll(in.readList(NameOrDefinition::new));
            this.field = in.readOptionalString();
            this.explain = in.readBoolean();
            this.attributes = in.readStringArray();
            this.normalizer = in.readOptionalString();
        }

        public Request(String index) {
            this.index(index);
        }

        public String[] text() {
            return this.text;
        }

        public Request text(String ... text) {
            this.text = text;
            return this;
        }

        public Request text(List<String> text) {
            this.text = text.toArray(new String[0]);
            return this;
        }

        public Request analyzer(String analyzer) {
            this.analyzer = analyzer;
            return this;
        }

        public String analyzer() {
            return this.analyzer;
        }

        public Request tokenizer(String tokenizer) {
            this.tokenizer = new NameOrDefinition(tokenizer);
            return this;
        }

        public Request tokenizer(Map<String, ?> tokenizer) {
            this.tokenizer = new NameOrDefinition(tokenizer);
            return this;
        }

        public void tokenizer(NameOrDefinition tokenizer) {
            this.tokenizer = tokenizer;
        }

        public NameOrDefinition tokenizer() {
            return this.tokenizer;
        }

        public Request addTokenFilter(String tokenFilter) {
            this.tokenFilters.add(new NameOrDefinition(tokenFilter));
            return this;
        }

        public Request addTokenFilter(Map<String, ?> tokenFilter) {
            this.tokenFilters.add(new NameOrDefinition(tokenFilter));
            return this;
        }

        public void setTokenFilters(List<NameOrDefinition> tokenFilters) {
            this.tokenFilters.addAll(tokenFilters);
        }

        public List<NameOrDefinition> tokenFilters() {
            return this.tokenFilters;
        }

        public Request addCharFilter(Map<String, ?> charFilter) {
            this.charFilters.add(new NameOrDefinition(charFilter));
            return this;
        }

        public Request addCharFilter(String charFilter) {
            this.charFilters.add(new NameOrDefinition(charFilter));
            return this;
        }

        public void setCharFilters(List<NameOrDefinition> charFilters) {
            this.charFilters.addAll(charFilters);
        }

        public List<NameOrDefinition> charFilters() {
            return this.charFilters;
        }

        public Request field(String field) {
            this.field = field;
            return this;
        }

        public String field() {
            return this.field;
        }

        public Request explain(boolean explain) {
            this.explain = explain;
            return this;
        }

        public boolean explain() {
            return this.explain;
        }

        public Request attributes(String ... attributes) {
            if (attributes == null) {
                throw new IllegalArgumentException("attributes must not be null");
            }
            this.attributes = attributes;
            return this;
        }

        public void attributes(List<String> attributes) {
            this.attributes = attributes.toArray(new String[0]);
        }

        public String[] attributes() {
            return this.attributes;
        }

        public String normalizer() {
            return this.normalizer;
        }

        public Request normalizer(String normalizer) {
            this.normalizer = normalizer;
            return this;
        }

        @Override
        public ActionRequestValidationException validate() {
            ActionRequestValidationException validationException = null;
            if (this.text == null || this.text.length == 0) {
                validationException = ValidateActions.addValidationError("text is missing", validationException);
            }
            if ((this.index == null || this.index.length() == 0) && this.normalizer != null) {
                validationException = ValidateActions.addValidationError("index is required if normalizer is specified", validationException);
            }
            if (this.normalizer != null && (this.tokenizer != null || this.analyzer != null)) {
                validationException = ValidateActions.addValidationError("tokenizer/analyze should be null if normalizer is specified", validationException);
            }
            if (!(this.analyzer == null || this.tokenizer == null && this.charFilters.isEmpty() && this.tokenFilters.isEmpty())) {
                validationException = ValidateActions.addValidationError("cannot define extra components on a named analyzer", validationException);
            }
            if (!(this.normalizer == null || this.tokenizer == null && this.charFilters.isEmpty() && this.tokenFilters.isEmpty())) {
                validationException = ValidateActions.addValidationError("cannot define extra components on a named normalizer", validationException);
            }
            if (!(this.field == null || this.tokenizer == null && this.charFilters.isEmpty() && this.tokenFilters.isEmpty())) {
                validationException = ValidateActions.addValidationError("cannot define extra components on a field-specific analyzer", validationException);
            }
            return validationException;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeStringArray(this.text);
            out.writeOptionalString(this.analyzer);
            out.writeOptionalWriteable(this.tokenizer);
            out.writeList(this.tokenFilters);
            out.writeList(this.charFilters);
            out.writeOptionalString(this.field);
            out.writeBoolean(this.explain);
            out.writeStringArray(this.attributes);
            out.writeOptionalString(this.normalizer);
        }

        public static Request fromXContent(XContentParser parser, String index) throws IOException {
            Request request = new Request(index);
            PARSER.parse(parser, request, null);
            return request;
        }

        static {
            PARSER.declareStringArray(Request::text, new ParseField("text", new String[0]));
            PARSER.declareString(Request::analyzer, new ParseField("analyzer", new String[0]));
            PARSER.declareField(Request::tokenizer, (p, c) -> NameOrDefinition.fromXContent(p), new ParseField("tokenizer", new String[0]), ObjectParser.ValueType.OBJECT_OR_STRING);
            PARSER.declareObjectArray(Request::setTokenFilters, (p, c) -> NameOrDefinition.fromXContent(p), new ParseField("filter", new String[0]));
            PARSER.declareObjectArray(Request::setCharFilters, (p, c) -> NameOrDefinition.fromXContent(p), new ParseField("char_filter", new String[0]));
            PARSER.declareString(Request::field, new ParseField("field", new String[0]));
            PARSER.declareBoolean(Request::explain, new ParseField("explain", new String[0]));
            PARSER.declareStringArray(Request::attributes, new ParseField("attributes", new String[0]));
            PARSER.declareString(Request::normalizer, new ParseField("normalizer", new String[0]));
        }
    }
}

