/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch;

import java.io.IOException;
import java.net.URL;
import java.security.CodeSource;
import java.util.Objects;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.Version;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.Booleans;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.io.FileSystemUtils;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.io.stream.StreamInput;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.io.stream.StreamOutput;

public class Build {
    public static final Build CURRENT;
    private final boolean isSnapshot;
    private final Flavor flavor;
    private final Type type;
    private final String hash;
    private final String date;
    private final String version;

    static URL getElasticsearchCodeSourceLocation() {
        CodeSource codeSource = Build.class.getProtectionDomain().getCodeSource();
        return codeSource == null ? null : codeSource.getLocation();
    }

    public Build(Flavor flavor, Type type, String hash, String date, boolean isSnapshot, String version) {
        this.flavor = flavor;
        this.type = type;
        this.hash = hash;
        this.date = date;
        this.isSnapshot = isSnapshot;
        this.version = version;
    }

    public String hash() {
        return this.hash;
    }

    public String date() {
        return this.date;
    }

    public static Build readBuild(StreamInput in) throws IOException {
        Flavor flavor = in.getVersion().onOrAfter(Version.V_6_3_0) ? Flavor.fromDisplayName(in.readString(), false) : Flavor.OSS;
        Type type = in.getVersion().onOrAfter(Version.V_6_3_0) ? Type.fromDisplayName(in.readString(), false) : Type.UNKNOWN;
        String hash = in.readString();
        String date = in.readString();
        boolean snapshot = in.readBoolean();
        String version = in.getVersion().onOrAfter(Version.V_7_0_0) ? in.readString() : in.getVersion().toString();
        return new Build(flavor, type, hash, date, snapshot, version);
    }

    public static void writeBuild(Build build, StreamOutput out) throws IOException {
        if (out.getVersion().onOrAfter(Version.V_6_3_0)) {
            out.writeString(build.flavor().displayName());
        }
        if (out.getVersion().onOrAfter(Version.V_6_3_0)) {
            Type buildType = out.getVersion().before(Version.V_6_7_0) && build.type() == Type.DOCKER ? Type.TAR : build.type();
            out.writeString(buildType.displayName());
        }
        out.writeString(build.hash());
        out.writeString(build.date());
        out.writeBoolean(build.isSnapshot());
        if (out.getVersion().onOrAfter(Version.V_7_0_0)) {
            out.writeString(build.getQualifiedVersion());
        }
    }

    public String getQualifiedVersion() {
        return this.version;
    }

    public Flavor flavor() {
        return this.flavor;
    }

    public Type type() {
        return this.type;
    }

    public boolean isSnapshot() {
        return this.isSnapshot;
    }

    public boolean isProductionRelease() {
        return this.version.matches("[0-9]+\\.[0-9]+\\.[0-9]+");
    }

    public String toString() {
        return "[" + this.flavor.displayName() + "][" + this.type.displayName + "][" + this.hash + "][" + this.date + "][" + this.version + "]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Build build = (Build)o;
        if (!this.flavor.equals((Object)build.flavor)) {
            return false;
        }
        if (!this.type.equals((Object)build.type)) {
            return false;
        }
        if (this.isSnapshot != build.isSnapshot) {
            return false;
        }
        if (!this.hash.equals(build.hash)) {
            return false;
        }
        if (!this.version.equals(build.version)) {
            return false;
        }
        return this.date.equals(build.date);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.flavor, this.type, this.isSnapshot, this.hash, this.date, this.version});
    }

    static {
        String version;
        boolean isSnapshot;
        String date;
        String hash;
        Type type;
        Flavor flavor;
        block15: {
            String urlStr;
            flavor = Flavor.fromDisplayName(System.getProperty("es.distribution.flavor", "unknown"), true);
            type = Type.fromDisplayName(System.getProperty("es.distribution.type", "unknown"), true);
            String esPrefix = "elasticsearch-" + Version.CURRENT;
            URL url = Build.getElasticsearchCodeSourceLocation();
            String string = urlStr = url == null ? "" : url.toString();
            if (urlStr.startsWith("file:/") && (urlStr.endsWith(esPrefix + ".jar") || urlStr.matches("(.*)" + esPrefix + "(-)?((alpha|beta|rc)[0-9]+)?(-SNAPSHOT)?.jar"))) {
                try (JarInputStream jar = new JarInputStream(FileSystemUtils.openFileURLStream(url));){
                    Manifest manifest = jar.getManifest();
                    hash = manifest.getMainAttributes().getValue("Change");
                    date = manifest.getMainAttributes().getValue("Build-Date");
                    isSnapshot = "true".equals(manifest.getMainAttributes().getValue("X-Compile-Elasticsearch-Snapshot"));
                    version = manifest.getMainAttributes().getValue("X-Compile-Elasticsearch-Version");
                    break block15;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            hash = "unknown";
            date = "unknown";
            version = Version.CURRENT.toString();
            String buildSnapshot = System.getProperty("build.snapshot");
            if (buildSnapshot != null) {
                try {
                    Class.forName("com.carrotsearch.randomizedtesting.RandomizedContext");
                }
                catch (ClassNotFoundException e) {
                    throw new IllegalStateException("build.snapshot set to [" + buildSnapshot + "] but not running tests");
                }
                isSnapshot = Booleans.parseBoolean(buildSnapshot);
            } else {
                isSnapshot = true;
            }
        }
        if (hash == null) {
            throw new IllegalStateException("Error finding the build hash. Stopping Elasticsearch now so it doesn't run in subtly broken ways. This is likely a build bug.");
        }
        if (date == null) {
            throw new IllegalStateException("Error finding the build date. Stopping Elasticsearch now so it doesn't run in subtly broken ways. This is likely a build bug.");
        }
        if (version == null) {
            throw new IllegalStateException("Error finding the build version. Stopping Elasticsearch now so it doesn't run in subtly broken ways. This is likely a build bug.");
        }
        CURRENT = new Build(flavor, type, hash, date, isSnapshot, version);
    }

    public static enum Type {
        DEB("deb"),
        DOCKER("docker"),
        RPM("rpm"),
        TAR("tar"),
        ZIP("zip"),
        UNKNOWN("unknown");

        final String displayName;

        public String displayName() {
            return this.displayName;
        }

        private Type(String displayName) {
            this.displayName = displayName;
        }

        public static Type fromDisplayName(String displayName, boolean strict) {
            switch (displayName) {
                case "deb": {
                    return DEB;
                }
                case "docker": {
                    return DOCKER;
                }
                case "rpm": {
                    return RPM;
                }
                case "tar": {
                    return TAR;
                }
                case "zip": {
                    return ZIP;
                }
                case "unknown": {
                    return UNKNOWN;
                }
            }
            if (strict) {
                throw new IllegalStateException("unexpected distribution type [" + displayName + "]; your distribution is broken");
            }
            return UNKNOWN;
        }
    }

    public static enum Flavor {
        DEFAULT("default"),
        OSS("oss"),
        UNKNOWN("unknown");

        final String displayName;

        private Flavor(String displayName) {
            this.displayName = displayName;
        }

        public String displayName() {
            return this.displayName;
        }

        public static Flavor fromDisplayName(String displayName, boolean strict) {
            switch (displayName) {
                case "default": {
                    return DEFAULT;
                }
                case "oss": {
                    return OSS;
                }
                case "unknown": {
                    return UNKNOWN;
                }
            }
            if (strict) {
                String message = "unexpected distribution flavor [" + displayName + "]; your distribution is broken";
                throw new IllegalStateException(message);
            }
            return UNKNOWN;
        }
    }
}

