/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.uhighlight;

import java.text.BreakIterator;
import java.text.CharacterIterator;

public class LengthGoalBreakIterator
extends BreakIterator {
    private final BreakIterator baseIter;
    private final int lengthGoal;
    private final boolean isMinimumLength;

    public static LengthGoalBreakIterator createMinLength(BreakIterator baseIter, int minLength) {
        return new LengthGoalBreakIterator(baseIter, minLength, true);
    }

    public static LengthGoalBreakIterator createClosestToLength(BreakIterator baseIter, int targetLength) {
        return new LengthGoalBreakIterator(baseIter, targetLength, false);
    }

    private LengthGoalBreakIterator(BreakIterator baseIter, int lengthGoal, boolean isMinimumLength) {
        this.baseIter = baseIter;
        this.lengthGoal = lengthGoal;
        this.isMinimumLength = isMinimumLength;
    }

    public String toString() {
        String goalDesc = this.isMinimumLength ? "minLen" : "targetLen";
        return this.getClass().getSimpleName() + "{" + goalDesc + "=" + this.lengthGoal + ", baseIter=" + this.baseIter + "}";
    }

    @Override
    public Object clone() {
        return new LengthGoalBreakIterator((BreakIterator)this.baseIter.clone(), this.lengthGoal, this.isMinimumLength);
    }

    @Override
    public CharacterIterator getText() {
        return this.baseIter.getText();
    }

    @Override
    public void setText(String newText) {
        this.baseIter.setText(newText);
    }

    @Override
    public void setText(CharacterIterator newText) {
        this.baseIter.setText(newText);
    }

    @Override
    public int current() {
        return this.baseIter.current();
    }

    @Override
    public int first() {
        return this.baseIter.first();
    }

    @Override
    public int last() {
        return this.baseIter.last();
    }

    @Override
    public int next(int n) {
        assert (false) : "Not supported";
        return this.baseIter.next(n);
    }

    @Override
    public int next() {
        return this.following(this.current());
    }

    @Override
    public int previous() {
        assert (false) : "Not supported";
        return this.baseIter.previous();
    }

    @Override
    public int following(int followingIdx) {
        int startIdx = this.current();
        if (followingIdx < startIdx) {
            assert (false) : "Not supported";
            return this.baseIter.following(followingIdx);
        }
        int targetIdx = startIdx + this.lengthGoal;
        if (followingIdx >= targetIdx - 1) {
            return this.baseIter.following(followingIdx);
        }
        if (targetIdx >= this.getText().getEndIndex()) {
            return this.baseIter.last();
        }
        int afterIdx = this.baseIter.following(targetIdx - 1);
        if (afterIdx == -1) {
            return this.current();
        }
        if (afterIdx == targetIdx) {
            return afterIdx;
        }
        if (this.isMinimumLength) {
            return afterIdx;
        }
        int beforeIdx = this.baseIter.preceding(targetIdx);
        if (beforeIdx <= followingIdx) {
            return this.moveToBreak(afterIdx);
        }
        if (targetIdx - beforeIdx <= afterIdx - targetIdx) {
            return beforeIdx;
        }
        return this.moveToBreak(afterIdx);
    }

    private int moveToBreak(int idx) {
        int current = this.baseIter.following(idx - 2);
        assert (current == idx) : "following() didn't move us to the expected index.";
        return idx;
    }

    @Override
    public int preceding(int offset) {
        return this.baseIter.preceding(offset);
    }

    @Override
    public boolean isBoundary(int offset) {
        assert (false) : "Not supported";
        return this.baseIter.isBoundary(offset);
    }
}

