/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.suggest;

import java.io.IOException;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.codecs.CodecUtil;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.suggest.InputIterator;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.store.ByteArrayDataInput;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.store.ByteArrayDataOutput;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.store.Directory;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.store.IOContext;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.store.IndexOutput;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.ArrayUtil;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.BytesRef;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.IOUtils;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.OfflineSorter;

public class SortedInputIterator
implements InputIterator {
    private final InputIterator source;
    private IndexOutput tempInput;
    private String tempSortedFileName;
    private final OfflineSorter.ByteSequencesReader reader;
    private final Comparator<BytesRef> comparator;
    private final boolean hasPayloads;
    private final boolean hasContexts;
    private final Directory tempDir;
    private final String tempFileNamePrefix;
    private boolean done = false;
    private long weight;
    private BytesRef payload = new BytesRef();
    private Set<BytesRef> contexts = null;
    private final Comparator<BytesRef> tieBreakByCostComparator = new Comparator<BytesRef>(){
        private final BytesRef leftScratch = new BytesRef();
        private final BytesRef rightScratch = new BytesRef();
        private final ByteArrayDataInput input = new ByteArrayDataInput();

        @Override
        public int compare(BytesRef left, BytesRef right) {
            int cmp;
            assert (left != right);
            this.leftScratch.bytes = left.bytes;
            this.leftScratch.offset = left.offset;
            this.leftScratch.length = left.length;
            this.rightScratch.bytes = right.bytes;
            this.rightScratch.offset = right.offset;
            this.rightScratch.length = right.length;
            long leftCost = SortedInputIterator.this.decode(this.leftScratch, this.input);
            long rightCost = SortedInputIterator.this.decode(this.rightScratch, this.input);
            if (SortedInputIterator.this.hasPayloads) {
                SortedInputIterator.this.decodePayload(this.leftScratch, this.input);
                SortedInputIterator.this.decodePayload(this.rightScratch, this.input);
            }
            if (SortedInputIterator.this.hasContexts) {
                SortedInputIterator.this.decodeContexts(this.leftScratch, this.input);
                SortedInputIterator.this.decodeContexts(this.rightScratch, this.input);
            }
            if ((cmp = SortedInputIterator.this.comparator.compare(this.leftScratch, this.rightScratch)) != 0) {
                return cmp;
            }
            return Long.compare(leftCost, rightCost);
        }
    };

    public SortedInputIterator(Directory tempDir, String tempFileNamePrefix, InputIterator source) throws IOException {
        this(tempDir, tempFileNamePrefix, source, Comparator.naturalOrder());
    }

    public SortedInputIterator(Directory tempDir, String tempFileNamePrefix, InputIterator source, Comparator<BytesRef> comparator) throws IOException {
        this.hasPayloads = source.hasPayloads();
        this.hasContexts = source.hasContexts();
        this.source = source;
        this.comparator = comparator;
        this.tempDir = tempDir;
        this.tempFileNamePrefix = tempFileNamePrefix;
        this.reader = this.sort();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BytesRef next() throws IOException {
        boolean success = false;
        if (this.done) {
            return null;
        }
        try {
            ByteArrayDataInput input = new ByteArrayDataInput();
            BytesRef bytes = this.reader.next();
            if (bytes != null) {
                this.weight = this.decode(bytes, input);
                if (this.hasPayloads) {
                    this.payload = this.decodePayload(bytes, input);
                }
                if (this.hasContexts) {
                    this.contexts = this.decodeContexts(bytes, input);
                }
                success = true;
                BytesRef bytesRef = bytes;
                return bytesRef;
            }
            this.close();
            this.done = true;
            success = true;
            BytesRef bytesRef = null;
            return bytesRef;
        }
        finally {
            if (!success) {
                this.done = true;
                this.close();
            }
        }
    }

    @Override
    public long weight() {
        return this.weight;
    }

    @Override
    public BytesRef payload() {
        if (this.hasPayloads) {
            return this.payload;
        }
        return null;
    }

    @Override
    public boolean hasPayloads() {
        return this.hasPayloads;
    }

    @Override
    public Set<BytesRef> contexts() {
        return this.contexts;
    }

    @Override
    public boolean hasContexts() {
        return this.hasContexts;
    }

    private OfflineSorter.ByteSequencesReader sort() throws IOException {
        OfflineSorter sorter = new OfflineSorter(this.tempDir, this.tempFileNamePrefix, this.tieBreakByCostComparator);
        this.tempInput = this.tempDir.createTempOutput(this.tempFileNamePrefix, "input", IOContext.DEFAULT);
        try (OfflineSorter.ByteSequencesWriter writer = new OfflineSorter.ByteSequencesWriter(this.tempInput);){
            BytesRef spare;
            byte[] buffer = new byte[]{};
            ByteArrayDataOutput output = new ByteArrayDataOutput(buffer);
            while ((spare = this.source.next()) != null) {
                this.encode(writer, output, buffer, spare, this.source.payload(), this.source.contexts(), this.source.weight());
            }
            CodecUtil.writeFooter(this.tempInput);
        }
        this.tempSortedFileName = sorter.sort(this.tempInput.getName());
        return new OfflineSorter.ByteSequencesReader(this.tempDir.openChecksumInput(this.tempSortedFileName, IOContext.READONCE), this.tempSortedFileName);
    }

    private void close() throws IOException {
        try {
            IOUtils.close(this.reader);
        }
        catch (Throwable throwable) {
            IOUtils.deleteFilesIgnoringExceptions(this.tempDir, this.tempInput == null ? null : this.tempInput.getName(), this.tempSortedFileName);
            throw throwable;
        }
        IOUtils.deleteFilesIgnoringExceptions(this.tempDir, this.tempInput == null ? null : this.tempInput.getName(), this.tempSortedFileName);
    }

    protected void encode(OfflineSorter.ByteSequencesWriter writer, ByteArrayDataOutput output, byte[] buffer, BytesRef spare, BytesRef payload, Set<BytesRef> contexts, long weight) throws IOException {
        int requiredLength = spare.length + 8 + (this.hasPayloads ? 2 + payload.length : 0);
        if (this.hasContexts) {
            for (BytesRef ctx : contexts) {
                requiredLength += 2 + ctx.length;
            }
            requiredLength += 2;
        }
        if (requiredLength >= buffer.length) {
            buffer = ArrayUtil.grow(buffer, requiredLength);
        }
        output.reset(buffer);
        output.writeBytes(spare.bytes, spare.offset, spare.length);
        if (this.hasContexts) {
            for (BytesRef ctx : contexts) {
                output.writeBytes(ctx.bytes, ctx.offset, ctx.length);
                output.writeShort((short)ctx.length);
            }
            output.writeShort((short)contexts.size());
        }
        if (this.hasPayloads) {
            output.writeBytes(payload.bytes, payload.offset, payload.length);
            output.writeShort((short)payload.length);
        }
        output.writeLong(weight);
        writer.write(buffer, 0, output.getPosition());
    }

    protected long decode(BytesRef scratch, ByteArrayDataInput tmpInput) {
        tmpInput.reset(scratch.bytes, scratch.offset, scratch.length);
        tmpInput.skipBytes(scratch.length - 8);
        scratch.length -= 8;
        return tmpInput.readLong();
    }

    protected Set<BytesRef> decodeContexts(BytesRef scratch, ByteArrayDataInput tmpInput) {
        tmpInput.reset(scratch.bytes, scratch.offset, scratch.length);
        tmpInput.skipBytes(scratch.length - 2);
        short ctxSetSize = tmpInput.readShort();
        scratch.length -= 2;
        HashSet<BytesRef> contextSet = new HashSet<BytesRef>();
        for (short i = 0; i < ctxSetSize; i = (short)(i + 1)) {
            tmpInput.setPosition(scratch.offset + scratch.length - 2);
            short curContextLength = tmpInput.readShort();
            scratch.length -= 2;
            tmpInput.setPosition(scratch.offset + scratch.length - curContextLength);
            BytesRef contextSpare = new BytesRef(curContextLength);
            tmpInput.readBytes(contextSpare.bytes, 0, curContextLength);
            contextSpare.length = curContextLength;
            contextSet.add(contextSpare);
            scratch.length -= curContextLength;
        }
        return contextSet;
    }

    protected BytesRef decodePayload(BytesRef scratch, ByteArrayDataInput tmpInput) {
        tmpInput.reset(scratch.bytes, scratch.offset, scratch.length);
        tmpInput.skipBytes(scratch.length - 2);
        short payloadLength = tmpInput.readShort();
        assert (payloadLength >= 0) : payloadLength;
        tmpInput.setPosition(scratch.offset + scratch.length - 2 - payloadLength);
        BytesRef payloadScratch = new BytesRef(payloadLength);
        tmpInput.readBytes(payloadScratch.bytes, 0, payloadLength);
        payloadScratch.length = payloadLength;
        scratch.length -= 2;
        scratch.length -= payloadLength;
        return payloadScratch;
    }
}

