/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.similarities;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.Explanation;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.similarities.BasicStats;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.similarities.LMSimilarity;

public class LMDirichletSimilarity
extends LMSimilarity {
    private final float mu;

    public LMDirichletSimilarity(LMSimilarity.CollectionModel collectionModel, float mu) {
        super(collectionModel);
        if (!Float.isFinite(mu) || mu < 0.0f) {
            throw new IllegalArgumentException("illegal mu value: " + mu + ", must be a non-negative finite value");
        }
        this.mu = mu;
    }

    public LMDirichletSimilarity(float mu) {
        if (!Float.isFinite(mu) || mu < 0.0f) {
            throw new IllegalArgumentException("illegal mu value: " + mu + ", must be a non-negative finite value");
        }
        this.mu = mu;
    }

    public LMDirichletSimilarity(LMSimilarity.CollectionModel collectionModel) {
        this(collectionModel, 2000.0f);
    }

    public LMDirichletSimilarity() {
        this(2000.0f);
    }

    @Override
    protected double score(BasicStats stats, double freq, double docLen) {
        double score = stats.getBoost() * (Math.log(1.0 + freq / ((double)this.mu * ((LMSimilarity.LMStats)stats).getCollectionProbability())) + Math.log((double)this.mu / (docLen + (double)this.mu)));
        return score > 0.0 ? score : 0.0;
    }

    @Override
    protected void explain(List<Explanation> subs, BasicStats stats, double freq, double docLen) {
        if (stats.getBoost() != 1.0) {
            subs.add(Explanation.match((Number)Float.valueOf((float)stats.getBoost()), "query boost", new Explanation[0]));
        }
        double p = ((LMSimilarity.LMStats)stats).getCollectionProbability();
        Explanation explP = Explanation.match((Number)Float.valueOf((float)p), "P, probability that the current term is generated by the collection", new Explanation[0]);
        Explanation explFreq = Explanation.match((Number)Float.valueOf((float)freq), "freq, number of occurrences of term in the document", new Explanation[0]);
        subs.add(Explanation.match((Number)Float.valueOf(this.mu), "mu", new Explanation[0]));
        Explanation weightExpl = Explanation.match((Number)Float.valueOf((float)Math.log(1.0 + freq / ((double)this.mu * ((LMSimilarity.LMStats)stats).getCollectionProbability()))), "term weight, computed as log(1 + freq /(mu * P)) from:", explFreq, explP);
        subs.add(weightExpl);
        subs.add(Explanation.match((Number)Float.valueOf((float)Math.log((double)this.mu / (docLen + (double)this.mu))), "document norm, computed as log(mu / (dl + mu))", new Explanation[0]));
        subs.add(Explanation.match((Number)Float.valueOf((float)docLen), "dl, length of field", new Explanation[0]));
        super.explain(subs, stats, freq, docLen);
    }

    @Override
    protected Explanation explain(BasicStats stats, Explanation freq, double docLen) {
        ArrayList<Explanation> subs = new ArrayList<Explanation>();
        this.explain(subs, stats, freq.getValue().doubleValue(), docLen);
        return Explanation.match((Number)Float.valueOf((float)this.score(stats, freq.getValue().doubleValue(), docLen)), "score(" + this.getClass().getSimpleName() + ", freq=" + freq.getValue() + "), computed as boost * (term weight + document norm) from:", subs);
    }

    public float getMu() {
        return this.mu;
    }

    @Override
    public String getName() {
        return String.format(Locale.ROOT, "Dirichlet(%f)", Float.valueOf(this.getMu()));
    }
}

