/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import java.util.function.ToLongFunction;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.analysis.Analyzer;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.DocValuesUpdate;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.DocumentsWriterDeleteQueue;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.DocumentsWriterFlushControl;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.DocumentsWriterFlushQueue;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.DocumentsWriterPerThread;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.DocumentsWriterPerThreadPool;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.FieldInfos;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.FlushPolicy;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.IndexableField;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.LiveIndexWriterConfig;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.SegmentInfo;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.Term;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.Query;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.store.AlreadyClosedException;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.store.Directory;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.Accountable;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.IOUtils;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.InfoStream;

final class DocumentsWriter
implements Closeable,
Accountable {
    private final Directory directoryOrig;
    private final Directory directory;
    private final FieldInfos.FieldNumbers globalFieldNumberMap;
    private final int indexCreatedVersionMajor;
    private final AtomicLong pendingNumDocs;
    private final boolean enableTestPoints;
    private final Supplier<String> segmentNameSupplier;
    private final FlushNotifications flushNotifications;
    private volatile boolean closed;
    private final InfoStream infoStream;
    private final LiveIndexWriterConfig config;
    private final AtomicInteger numDocsInRAM = new AtomicInteger(0);
    volatile DocumentsWriterDeleteQueue deleteQueue;
    private final DocumentsWriterFlushQueue ticketQueue = new DocumentsWriterFlushQueue();
    private volatile boolean pendingChangesInCurrentFullFlush;
    final DocumentsWriterPerThreadPool perThreadPool;
    final FlushPolicy flushPolicy;
    final DocumentsWriterFlushControl flushControl;
    private long lastSeqNo;
    private volatile DocumentsWriterDeleteQueue currentFullFlushDelQueue = null;

    DocumentsWriter(FlushNotifications flushNotifications, int indexCreatedVersionMajor, AtomicLong pendingNumDocs, boolean enableTestPoints, Supplier<String> segmentNameSupplier, LiveIndexWriterConfig config, Directory directoryOrig, Directory directory, FieldInfos.FieldNumbers globalFieldNumberMap) {
        this.indexCreatedVersionMajor = indexCreatedVersionMajor;
        this.directoryOrig = directoryOrig;
        this.directory = directory;
        this.config = config;
        this.infoStream = config.getInfoStream();
        this.deleteQueue = new DocumentsWriterDeleteQueue(this.infoStream);
        this.perThreadPool = config.getIndexerThreadPool();
        this.flushPolicy = config.getFlushPolicy();
        this.globalFieldNumberMap = globalFieldNumberMap;
        this.pendingNumDocs = pendingNumDocs;
        this.flushControl = new DocumentsWriterFlushControl(this, config);
        this.segmentNameSupplier = segmentNameSupplier;
        this.enableTestPoints = enableTestPoints;
        this.flushNotifications = flushNotifications;
    }

    long deleteQueries(Query ... queries) throws IOException {
        return this.applyDeleteOrUpdate(q -> q.addDelete(queries));
    }

    void setLastSeqNo(long seqNo) {
        this.lastSeqNo = seqNo;
    }

    long deleteTerms(Term ... terms) throws IOException {
        return this.applyDeleteOrUpdate(q -> q.addDelete(terms));
    }

    long updateDocValues(DocValuesUpdate ... updates) throws IOException {
        return this.applyDeleteOrUpdate(q -> q.addDocValuesUpdates(updates));
    }

    private synchronized long applyDeleteOrUpdate(ToLongFunction<DocumentsWriterDeleteQueue> function) throws IOException {
        DocumentsWriterDeleteQueue deleteQueue = this.deleteQueue;
        long seqNo = function.applyAsLong(deleteQueue);
        this.flushControl.doOnDelete();
        this.lastSeqNo = Math.max(this.lastSeqNo, seqNo);
        if (this.applyAllDeletes()) {
            seqNo = -seqNo;
        }
        return seqNo;
    }

    private boolean applyAllDeletes() throws IOException {
        DocumentsWriterDeleteQueue deleteQueue = this.deleteQueue;
        if (!this.flushControl.isFullFlush() && deleteQueue.isOpen() && this.flushControl.getAndResetApplyAllDeletes() && this.ticketQueue.addDeletes(deleteQueue)) {
            this.flushNotifications.onDeletesApplied();
            return true;
        }
        return false;
    }

    void purgeFlushTickets(boolean forced, IOUtils.IOConsumer<DocumentsWriterFlushQueue.FlushTicket> consumer) throws IOException {
        if (forced) {
            this.ticketQueue.forcePurge(consumer);
        } else {
            this.ticketQueue.tryPurge(consumer);
        }
    }

    int getNumDocs() {
        return this.numDocsInRAM.get();
    }

    private void ensureOpen() throws AlreadyClosedException {
        if (this.closed) {
            throw new AlreadyClosedException("this DocumentsWriter is closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void abort() throws IOException {
        boolean success = false;
        try {
            this.deleteQueue.clear();
            if (this.infoStream.isEnabled("DW")) {
                this.infoStream.message("DW", "abort");
            }
            int limit = this.perThreadPool.getActiveThreadStateCount();
            for (int i = 0; i < limit; ++i) {
                DocumentsWriterPerThreadPool.ThreadState perThread = this.perThreadPool.getThreadState(i);
                perThread.lock();
                try {
                    this.abortThreadState(perThread);
                    continue;
                }
                finally {
                    perThread.unlock();
                }
            }
            this.flushControl.abortPendingFlushes();
            this.flushControl.waitForFlush();
            success = true;
        }
        finally {
            if (this.infoStream.isEnabled("DW")) {
                this.infoStream.message("DW", "done abort success=" + success);
            }
        }
    }

    final boolean flushOneDWPT() throws IOException {
        DocumentsWriterPerThread documentsWriterPerThread;
        if (this.infoStream.isEnabled("DW")) {
            this.infoStream.message("DW", "startFlushOneDWPT");
        }
        if ((documentsWriterPerThread = this.flushControl.nextPendingFlush()) == null) {
            documentsWriterPerThread = this.flushControl.checkoutLargestNonPendingWriter();
        }
        if (documentsWriterPerThread != null) {
            return this.doFlush(documentsWriterPerThread);
        }
        return false;
    }

    synchronized Closeable lockAndAbortAll() throws IOException {
        if (this.infoStream.isEnabled("DW")) {
            this.infoStream.message("DW", "lockAndAbortAll");
        }
        this.ticketQueue.forcePurge(ticket -> {
            if (ticket.getFlushedSegment() != null) {
                this.pendingNumDocs.addAndGet(-ticket.getFlushedSegment().segmentInfo.info.maxDoc());
            }
        });
        ArrayList<DocumentsWriterPerThreadPool.ThreadState> threadStates = new ArrayList<DocumentsWriterPerThreadPool.ThreadState>();
        AtomicBoolean released = new AtomicBoolean(false);
        Closeable release = () -> {
            if (released.compareAndSet(false, true)) {
                if (this.infoStream.isEnabled("DW")) {
                    this.infoStream.message("DW", "unlockAllAbortedThread");
                }
                this.perThreadPool.unlockNewThreadStates();
                for (DocumentsWriterPerThreadPool.ThreadState state : threadStates) {
                    state.unlock();
                }
            }
        };
        try {
            this.deleteQueue.clear();
            this.perThreadPool.lockNewThreadStates();
            int limit = this.perThreadPool.getMaxThreadStates();
            for (int i = 0; i < limit; ++i) {
                DocumentsWriterPerThreadPool.ThreadState perThread = this.perThreadPool.getThreadState(i);
                perThread.lock();
                threadStates.add(perThread);
                this.abortThreadState(perThread);
            }
            this.deleteQueue.clear();
            this.deleteQueue.skipSequenceNumbers(this.perThreadPool.getActiveThreadStateCount() + 1);
            this.flushControl.abortPendingFlushes();
            this.flushControl.waitForFlush();
            if (this.infoStream.isEnabled("DW")) {
                this.infoStream.message("DW", "finished lockAndAbortAll success=true");
            }
            return release;
        }
        catch (Throwable t) {
            if (this.infoStream.isEnabled("DW")) {
                this.infoStream.message("DW", "finished lockAndAbortAll success=false");
            }
            try {
                release.close();
            }
            catch (Throwable t1) {
                t.addSuppressed(t1);
            }
            throw t;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int abortThreadState(DocumentsWriterPerThreadPool.ThreadState perThread) throws IOException {
        assert (perThread.isHeldByCurrentThread());
        if (perThread.isInitialized()) {
            try {
                int abortedDocCount = perThread.dwpt.getNumDocsInRAM();
                this.subtractFlushedNumDocs(abortedDocCount);
                perThread.dwpt.abort();
                int n = abortedDocCount;
                return n;
            }
            finally {
                this.flushControl.doOnAbort(perThread);
            }
        }
        this.flushControl.doOnAbort(perThread);
        return 0;
    }

    public long getMaxCompletedSequenceNumber() {
        long value = this.lastSeqNo;
        int limit = this.perThreadPool.getMaxThreadStates();
        for (int i = 0; i < limit; ++i) {
            DocumentsWriterPerThreadPool.ThreadState perThread = this.perThreadPool.getThreadState(i);
            value = Math.max(value, perThread.lastSeqNo);
        }
        return value;
    }

    boolean anyChanges() {
        boolean anyChanges;
        boolean bl = anyChanges = this.numDocsInRAM.get() != 0 || this.anyDeletions() || this.ticketQueue.hasTickets() || this.pendingChangesInCurrentFullFlush;
        if (this.infoStream.isEnabled("DW") && anyChanges) {
            this.infoStream.message("DW", "anyChanges? numDocsInRam=" + this.numDocsInRAM.get() + " deletes=" + this.anyDeletions() + " hasTickets:" + this.ticketQueue.hasTickets() + " pendingChangesInFullFlush: " + this.pendingChangesInCurrentFullFlush);
        }
        return anyChanges;
    }

    public int getBufferedDeleteTermsSize() {
        return this.deleteQueue.getBufferedUpdatesTermsSize();
    }

    public int getNumBufferedDeleteTerms() {
        return this.deleteQueue.numGlobalTermDeletes();
    }

    public boolean anyDeletions() {
        return this.deleteQueue.anyChanges();
    }

    @Override
    public void close() {
        this.closed = true;
        this.flushControl.setClosed();
    }

    private boolean preUpdate() throws IOException {
        this.ensureOpen();
        boolean hasEvents = false;
        if (this.flushControl.anyStalledThreads() || this.flushControl.numQueuedFlushes() > 0 && this.config.checkPendingFlushOnUpdate) {
            while (true) {
                DocumentsWriterPerThread flushingDWPT;
                if ((flushingDWPT = this.flushControl.nextPendingFlush()) != null) {
                    hasEvents |= this.doFlush(flushingDWPT);
                    continue;
                }
                this.flushControl.waitIfStalled();
                if (this.flushControl.numQueuedFlushes() == 0) break;
            }
        }
        return hasEvents;
    }

    private boolean postUpdate(DocumentsWriterPerThread flushingDWPT, boolean hasEvents) throws IOException {
        DocumentsWriterPerThread nextPendingFlush;
        hasEvents |= this.applyAllDeletes();
        if (flushingDWPT != null) {
            hasEvents |= this.doFlush(flushingDWPT);
        } else if (this.config.checkPendingFlushOnUpdate && (nextPendingFlush = this.flushControl.nextPendingFlush()) != null) {
            hasEvents |= this.doFlush(nextPendingFlush);
        }
        return hasEvents;
    }

    private void ensureInitialized(DocumentsWriterPerThreadPool.ThreadState state) throws IOException {
        if (state.dwpt == null) {
            FieldInfos.Builder infos = new FieldInfos.Builder(this.globalFieldNumberMap);
            state.dwpt = new DocumentsWriterPerThread(this.indexCreatedVersionMajor, this.segmentNameSupplier.get(), this.directoryOrig, this.directory, this.config, this.infoStream, this.deleteQueue, infos, this.pendingNumDocs, this.enableTestPoints);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long updateDocuments(Iterable<? extends Iterable<? extends IndexableField>> docs, Analyzer analyzer, DocumentsWriterDeleteQueue.Node<?> delNode) throws IOException {
        DocumentsWriterPerThread flushingDWPT;
        long seqNo;
        boolean hasEvents = this.preUpdate();
        DocumentsWriterPerThreadPool.ThreadState perThread = this.flushControl.obtainAndLock();
        try {
            this.ensureOpen();
            this.ensureInitialized(perThread);
            assert (perThread.isInitialized());
            DocumentsWriterPerThread dwpt = perThread.dwpt;
            int dwptNumDocs = dwpt.getNumDocsInRAM();
            try {
                seqNo = dwpt.updateDocuments(docs, analyzer, delNode, this.flushNotifications);
            }
            finally {
                if (dwpt.isAborted()) {
                    this.flushControl.doOnAbort(perThread);
                }
                this.numDocsInRAM.addAndGet(dwpt.getNumDocsInRAM() - dwptNumDocs);
            }
            boolean isUpdate = delNode != null && delNode.isDelete();
            flushingDWPT = this.flushControl.doAfterDocument(perThread, isUpdate);
            assert (seqNo > perThread.lastSeqNo) : "seqNo=" + seqNo + " lastSeqNo=" + perThread.lastSeqNo;
            perThread.lastSeqNo = seqNo;
        }
        finally {
            this.perThreadPool.release(perThread);
        }
        if (this.postUpdate(flushingDWPT, hasEvents)) {
            seqNo = -seqNo;
        }
        return seqNo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long updateDocument(Iterable<? extends IndexableField> doc, Analyzer analyzer, DocumentsWriterDeleteQueue.Node<?> delNode) throws IOException {
        DocumentsWriterPerThread flushingDWPT;
        long seqNo;
        boolean hasEvents = this.preUpdate();
        DocumentsWriterPerThreadPool.ThreadState perThread = this.flushControl.obtainAndLock();
        try {
            this.ensureOpen();
            this.ensureInitialized(perThread);
            assert (perThread.isInitialized());
            DocumentsWriterPerThread dwpt = perThread.dwpt;
            int dwptNumDocs = dwpt.getNumDocsInRAM();
            try {
                seqNo = dwpt.updateDocument(doc, analyzer, delNode, this.flushNotifications);
            }
            finally {
                if (dwpt.isAborted()) {
                    this.flushControl.doOnAbort(perThread);
                }
                this.numDocsInRAM.addAndGet(dwpt.getNumDocsInRAM() - dwptNumDocs);
            }
            boolean isUpdate = delNode != null && delNode.isDelete();
            flushingDWPT = this.flushControl.doAfterDocument(perThread, isUpdate);
            assert (seqNo > perThread.lastSeqNo) : "seqNo=" + seqNo + " lastSeqNo=" + perThread.lastSeqNo;
            perThread.lastSeqNo = seqNo;
        }
        finally {
            this.perThreadPool.release(perThread);
        }
        if (this.postUpdate(flushingDWPT, hasEvents)) {
            seqNo = -seqNo;
        }
        return seqNo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doFlush(DocumentsWriterPerThread flushingDWPT) throws IOException {
        double ramBufferSizeMB;
        boolean hasEvents = false;
        while (flushingDWPT != null) {
            hasEvents = true;
            boolean success = false;
            DocumentsWriterFlushQueue.FlushTicket ticket = null;
            try {
                assert (this.currentFullFlushDelQueue == null || flushingDWPT.deleteQueue == this.currentFullFlushDelQueue) : "expected: " + this.currentFullFlushDelQueue + "but was: " + flushingDWPT.deleteQueue + " " + this.flushControl.isFullFlush();
                try {
                    assert (this.assertTicketQueueModification(flushingDWPT.deleteQueue));
                    ticket = this.ticketQueue.addFlushTicket(flushingDWPT);
                    int flushingDocsInRam = flushingDWPT.getNumDocsInRAM();
                    boolean dwptSuccess = false;
                    try {
                        DocumentsWriterPerThread.FlushedSegment newSegment = flushingDWPT.flush(this.flushNotifications);
                        this.ticketQueue.addSegment(ticket, newSegment);
                        dwptSuccess = true;
                    }
                    finally {
                        this.subtractFlushedNumDocs(flushingDocsInRam);
                        if (!flushingDWPT.pendingFilesToDelete().isEmpty()) {
                            Set<String> files = flushingDWPT.pendingFilesToDelete();
                            this.flushNotifications.deleteUnusedFiles(files);
                            hasEvents = true;
                        }
                        if (!dwptSuccess) {
                            this.flushNotifications.flushFailed(flushingDWPT.getSegmentInfo());
                            hasEvents = true;
                        }
                    }
                    success = true;
                }
                finally {
                    if (!success && ticket != null) {
                        this.ticketQueue.markTicketFailed(ticket);
                    }
                }
                if (this.ticketQueue.getTicketCount() >= this.perThreadPool.getActiveThreadStateCount()) {
                    this.flushNotifications.onTicketBacklog();
                    break;
                }
            }
            finally {
                this.flushControl.doAfterFlush(flushingDWPT);
            }
            flushingDWPT = this.flushControl.nextPendingFlush();
        }
        if (hasEvents) {
            this.flushNotifications.afterSegmentsFlushed();
        }
        if ((ramBufferSizeMB = this.config.getRAMBufferSizeMB()) != -1.0 && (double)this.flushControl.getDeleteBytesUsed() > 1048576.0 * ramBufferSizeMB / 2.0) {
            hasEvents = true;
            if (!this.applyAllDeletes()) {
                if (this.infoStream.isEnabled("DW")) {
                    this.infoStream.message("DW", String.format(Locale.ROOT, "force apply deletes after flush bytesUsed=%.1f MB vs ramBuffer=%.1f MB", (double)this.flushControl.getDeleteBytesUsed() / 1048576.0, ramBufferSizeMB));
                }
                this.flushNotifications.onDeletesApplied();
            }
        }
        return hasEvents;
    }

    void subtractFlushedNumDocs(int numFlushed) {
        int oldValue = this.numDocsInRAM.get();
        while (!this.numDocsInRAM.compareAndSet(oldValue, oldValue - numFlushed)) {
            oldValue = this.numDocsInRAM.get();
        }
        assert (this.numDocsInRAM.get() >= 0);
    }

    private synchronized boolean setFlushingDeleteQueue(DocumentsWriterDeleteQueue session) {
        assert (this.currentFullFlushDelQueue == null || !this.currentFullFlushDelQueue.isOpen()) : "Can not replace a full flush queue if the queue is not closed";
        this.currentFullFlushDelQueue = session;
        return true;
    }

    private boolean assertTicketQueueModification(DocumentsWriterDeleteQueue deleteQueue) {
        DocumentsWriterDeleteQueue currentFullFlushDelQueue = this.currentFullFlushDelQueue;
        assert (currentFullFlushDelQueue == null || currentFullFlushDelQueue == deleteQueue) : "only modifications from the current flushing queue are permitted while doing a full flush";
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long flushAllThreads() throws IOException {
        long seqNo;
        DocumentsWriterDeleteQueue flushingDeleteQueue;
        if (this.infoStream.isEnabled("DW")) {
            this.infoStream.message("DW", "startFullFlush");
        }
        DocumentsWriter documentsWriter = this;
        synchronized (documentsWriter) {
            this.pendingChangesInCurrentFullFlush = this.anyChanges();
            flushingDeleteQueue = this.deleteQueue;
            seqNo = this.flushControl.markForFullFlush();
            assert (this.setFlushingDeleteQueue(flushingDeleteQueue));
        }
        assert (this.currentFullFlushDelQueue != null);
        assert (this.currentFullFlushDelQueue != this.deleteQueue);
        boolean anythingFlushed = false;
        try {
            DocumentsWriterPerThread flushingDWPT;
            while ((flushingDWPT = this.flushControl.nextPendingFlush()) != null) {
                anythingFlushed |= this.doFlush(flushingDWPT);
            }
            this.flushControl.waitForFlush();
            if (!anythingFlushed && flushingDeleteQueue.anyChanges()) {
                if (this.infoStream.isEnabled("DW")) {
                    this.infoStream.message("DW", Thread.currentThread().getName() + ": flush naked frozen global deletes");
                }
                assert (this.assertTicketQueueModification(flushingDeleteQueue));
                this.ticketQueue.addDeletes(flushingDeleteQueue);
            }
            assert (!flushingDeleteQueue.anyChanges());
        }
        finally {
            assert (flushingDeleteQueue == this.currentFullFlushDelQueue);
            flushingDeleteQueue.close();
        }
        if (anythingFlushed) {
            return -seqNo;
        }
        return seqNo;
    }

    void finishFullFlush(boolean success) throws IOException {
        try {
            if (this.infoStream.isEnabled("DW")) {
                this.infoStream.message("DW", Thread.currentThread().getName() + " finishFullFlush success=" + success);
            }
            assert (this.setFlushingDeleteQueue(null));
            if (success) {
                this.flushControl.finishFullFlush();
            } else {
                this.flushControl.abortFullFlushes();
            }
        }
        finally {
            this.pendingChangesInCurrentFullFlush = false;
            this.applyAllDeletes();
        }
    }

    @Override
    public long ramBytesUsed() {
        return this.flushControl.ramBytesUsed();
    }

    public long getFlushingBytes() {
        return this.flushControl.getFlushingBytes();
    }

    static interface FlushNotifications {
        public void deleteUnusedFiles(Collection<String> var1);

        public void flushFailed(SegmentInfo var1);

        public void afterSegmentsFlushed() throws IOException;

        public void onTragicEvent(Throwable var1, String var2);

        public void onDeletesApplied();

        public void onTicketBacklog();
    }
}

