/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.apache.lucene.geo;

import java.util.Arrays;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.geo.Polygon;

public class XYLine {
    private final double[] x;
    private final double[] y;
    public final double minX;
    public final double maxX;
    public final double minY;
    public final double maxY;

    public XYLine(float[] x, float[] y) {
        int i;
        if (x == null) {
            throw new IllegalArgumentException("x must not be null");
        }
        if (y == null) {
            throw new IllegalArgumentException("y must not be null");
        }
        if (x.length != y.length) {
            throw new IllegalArgumentException("x and y must be equal length");
        }
        if (x.length < 2) {
            throw new IllegalArgumentException("at least 2 line points required");
        }
        double minX = x[0];
        double minY = y[0];
        double maxX = x[0];
        double maxY = y[0];
        for (i = 0; i < x.length; ++i) {
            minX = Math.min((double)x[i], minX);
            minY = Math.min((double)y[i], minY);
            maxX = Math.max((double)x[i], maxX);
            maxY = Math.max((double)y[i], maxY);
        }
        this.x = new double[x.length];
        this.y = new double[y.length];
        for (i = 0; i < x.length; ++i) {
            this.x[i] = x[i];
            this.y[i] = y[i];
        }
        this.minX = minX;
        this.maxX = maxX;
        this.minY = minY;
        this.maxY = maxY;
    }

    public int numPoints() {
        return this.x.length;
    }

    public double getX(int vertex) {
        return this.x[vertex];
    }

    public double getY(int vertex) {
        return this.y[vertex];
    }

    public double[] getX() {
        return (double[])this.x.clone();
    }

    public double[] getY() {
        return (double[])this.y.clone();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof XYLine)) {
            return false;
        }
        XYLine line = (XYLine)o;
        return Arrays.equals(this.x, line.x) && Arrays.equals(this.y, line.y);
    }

    public int hashCode() {
        int result = Arrays.hashCode(this.x);
        result = 31 * result + Arrays.hashCode(this.y);
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("XYLINE(");
        for (int i = 0; i < this.x.length; ++i) {
            sb.append("[").append(this.x[i]).append(", ").append(this.y[i]).append("]");
        }
        sb.append(')');
        return sb.toString();
    }

    public String toGeoJSON() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        sb.append(Polygon.verticesToGeoJSON(this.x, this.y));
        sb.append("]");
        return sb.toString();
    }
}

