/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.com.carrotsearch.hppc;

import org.apache.flink.elasticsearch7.shaded.com.carrotsearch.hppc.BitMixer;
import org.apache.flink.elasticsearch7.shaded.com.carrotsearch.hppc.HashOrderMixing;
import org.apache.flink.elasticsearch7.shaded.com.carrotsearch.hppc.IntShortHashMap;

public class IntShortScatterMap
extends IntShortHashMap {
    public IntShortScatterMap() {
        this(4);
    }

    public IntShortScatterMap(int expectedElements) {
        this(expectedElements, 0.75);
    }

    public IntShortScatterMap(int expectedElements, double loadFactor) {
        super(expectedElements, loadFactor, HashOrderMixing.none());
    }

    @Override
    protected int hashKey(int key) {
        return BitMixer.mixPhi(key);
    }

    public static IntShortScatterMap from(int[] keys, short[] values) {
        if (keys.length != values.length) {
            throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
        }
        IntShortScatterMap map = new IntShortScatterMap(keys.length);
        for (int i = 0; i < keys.length; ++i) {
            map.put(keys[i], values[i]);
        }
        return map;
    }
}

