/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.elasticsearch;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.flink.annotation.Internal;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.ActionRequest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.delete.DeleteRequest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.index.IndexRequest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.update.UpdateRequest;
import org.apache.flink.streaming.connectors.elasticsearch.RequestIndexer;

@Internal
@NotThreadSafe
class BufferingNoOpRequestIndexer
implements RequestIndexer {
    private List<ActionRequest> bufferedRequests = new ArrayList<ActionRequest>(10);

    BufferingNoOpRequestIndexer() {
    }

    @Override
    public void add(DeleteRequest ... deleteRequests) {
        Collections.addAll(this.bufferedRequests, deleteRequests);
    }

    @Override
    public void add(IndexRequest ... indexRequests) {
        Collections.addAll(this.bufferedRequests, indexRequests);
    }

    @Override
    public void add(UpdateRequest ... updateRequests) {
        Collections.addAll(this.bufferedRequests, updateRequests);
    }

    void processBufferedRequests(RequestIndexer actualIndexer) {
        for (ActionRequest request : this.bufferedRequests) {
            if (request instanceof IndexRequest) {
                actualIndexer.add((IndexRequest)request);
                continue;
            }
            if (request instanceof DeleteRequest) {
                actualIndexer.add((DeleteRequest)request);
                continue;
            }
            if (!(request instanceof UpdateRequest)) continue;
            actualIndexer.add((UpdateRequest)request);
        }
        this.bufferedRequests.clear();
    }
}

