/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.transport;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.Nullable;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.io.stream.StreamInput;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.io.stream.StreamOutput;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.io.stream.Writeable;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.transport.BoundTransportAddress;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ToXContent;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ToXContentFragment;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentBuilder;

public class TransportInfo
implements Writeable,
ToXContentFragment {
    private BoundTransportAddress address;
    private Map<String, BoundTransportAddress> profileAddresses;

    public TransportInfo(BoundTransportAddress address, @Nullable Map<String, BoundTransportAddress> profileAddresses) {
        this.address = address;
        this.profileAddresses = profileAddresses;
    }

    public TransportInfo(StreamInput in) throws IOException {
        this.address = BoundTransportAddress.readBoundTransportAddress(in);
        int size = in.readVInt();
        if (size > 0) {
            this.profileAddresses = new HashMap<String, BoundTransportAddress>(size);
            for (int i = 0; i < size; ++i) {
                String key = in.readString();
                BoundTransportAddress value = BoundTransportAddress.readBoundTransportAddress(in);
                this.profileAddresses.put(key, value);
            }
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        this.address.writeTo(out);
        if (this.profileAddresses != null) {
            out.writeVInt(this.profileAddresses.size());
        } else {
            out.writeVInt(0);
        }
        if (this.profileAddresses != null && this.profileAddresses.size() > 0) {
            for (Map.Entry<String, BoundTransportAddress> entry : this.profileAddresses.entrySet()) {
                out.writeString(entry.getKey());
                entry.getValue().writeTo(out);
            }
        }
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("transport");
        builder.array("bound_address", this.address.boundAddresses());
        builder.field("publish_address", this.address.publishAddress().toString());
        builder.startObject("profiles");
        if (this.profileAddresses != null && this.profileAddresses.size() > 0) {
            for (Map.Entry<String, BoundTransportAddress> entry : this.profileAddresses.entrySet()) {
                builder.startObject(entry.getKey());
                builder.array("bound_address", entry.getValue().boundAddresses());
                builder.field("publish_address", entry.getValue().publishAddress().toString());
                builder.endObject();
            }
        }
        builder.endObject();
        builder.endObject();
        return builder;
    }

    public BoundTransportAddress address() {
        return this.address;
    }

    public BoundTransportAddress getAddress() {
        return this.address();
    }

    public Map<String, BoundTransportAddress> getProfileAddresses() {
        return this.profileAddresses();
    }

    public Map<String, BoundTransportAddress> profileAddresses() {
        return this.profileAddresses;
    }

    static final class Fields {
        static final String TRANSPORT = "transport";
        static final String BOUND_ADDRESS = "bound_address";
        static final String PUBLISH_ADDRESS = "publish_address";
        static final String PROFILES = "profiles";

        Fields() {
        }
    }
}

