/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.internal;

import java.io.IOException;
import java.util.Map;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.IndicesRequest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.OriginalIndices;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.search.SearchRequest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.search.SearchTask;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.search.SearchType;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.support.IndicesOptions;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.Nullable;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.bytes.BytesReference;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.io.stream.StreamInput;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.io.stream.StreamOutput;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.query.Rewriteable;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.shard.ShardId;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.Scroll;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.builder.SearchSourceBuilder;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.internal.AliasFilter;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.internal.ShardSearchLocalRequest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.internal.ShardSearchRequest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.tasks.Task;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.tasks.TaskId;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.transport.TransportRequest;

public class ShardSearchTransportRequest
extends TransportRequest
implements ShardSearchRequest,
IndicesRequest {
    private final OriginalIndices originalIndices;
    private final ShardSearchLocalRequest shardSearchLocalRequest;

    public ShardSearchTransportRequest(OriginalIndices originalIndices, SearchRequest searchRequest, ShardId shardId, int numberOfShards, AliasFilter aliasFilter, float indexBoost, long nowInMillis, @Nullable String clusterAlias, String[] indexRoutings) {
        this.shardSearchLocalRequest = new ShardSearchLocalRequest(searchRequest, shardId, numberOfShards, aliasFilter, indexBoost, nowInMillis, clusterAlias, indexRoutings);
        this.originalIndices = originalIndices;
    }

    public ShardSearchTransportRequest(StreamInput in) throws IOException {
        super(in);
        this.shardSearchLocalRequest = new ShardSearchLocalRequest(in);
        this.originalIndices = OriginalIndices.readOriginalIndices(in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        this.shardSearchLocalRequest.innerWriteTo(out, false);
        OriginalIndices.writeOriginalIndices(this.originalIndices, out);
    }

    @Override
    public String[] indices() {
        if (this.originalIndices == null) {
            return null;
        }
        return this.originalIndices.indices();
    }

    @Override
    public IndicesOptions indicesOptions() {
        if (this.originalIndices == null) {
            return null;
        }
        return this.originalIndices.indicesOptions();
    }

    @Override
    public ShardId shardId() {
        return this.shardSearchLocalRequest.shardId();
    }

    @Override
    public String[] types() {
        return this.shardSearchLocalRequest.types();
    }

    @Override
    public SearchSourceBuilder source() {
        return this.shardSearchLocalRequest.source();
    }

    @Override
    public AliasFilter getAliasFilter() {
        return this.shardSearchLocalRequest.getAliasFilter();
    }

    @Override
    public void setAliasFilter(AliasFilter filter) {
        this.shardSearchLocalRequest.setAliasFilter(filter);
    }

    @Override
    public void source(SearchSourceBuilder source) {
        this.shardSearchLocalRequest.source(source);
    }

    @Override
    public int numberOfShards() {
        return this.shardSearchLocalRequest.numberOfShards();
    }

    @Override
    public SearchType searchType() {
        return this.shardSearchLocalRequest.searchType();
    }

    @Override
    public float indexBoost() {
        return this.shardSearchLocalRequest.indexBoost();
    }

    @Override
    public long nowInMillis() {
        return this.shardSearchLocalRequest.nowInMillis();
    }

    @Override
    public Boolean requestCache() {
        return this.shardSearchLocalRequest.requestCache();
    }

    @Override
    public boolean allowPartialSearchResults() {
        return this.shardSearchLocalRequest.allowPartialSearchResults();
    }

    @Override
    public Scroll scroll() {
        return this.shardSearchLocalRequest.scroll();
    }

    @Override
    public String[] indexRoutings() {
        return this.shardSearchLocalRequest.indexRoutings();
    }

    @Override
    public String preference() {
        return this.shardSearchLocalRequest.preference();
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        throw new UnsupportedOperationException("usage of Streamable is to be replaced by Writeable");
    }

    @Override
    public BytesReference cacheKey() throws IOException {
        return this.shardSearchLocalRequest.cacheKey();
    }

    @Override
    public Task createTask(long id, String type, String action, TaskId parentTaskId, Map<String, String> headers) {
        return new SearchTask(id, type, action, this.getDescription(), parentTaskId, headers);
    }

    @Override
    public String getDescription() {
        return "shardId[" + this.shardSearchLocalRequest.shardId() + "]";
    }

    @Override
    public String getClusterAlias() {
        return this.shardSearchLocalRequest.getClusterAlias();
    }

    @Override
    public Rewriteable<Rewriteable> getRewriteable() {
        return this.shardSearchLocalRequest.getRewriteable();
    }
}

