/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.pipeline;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.ParseField;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.io.stream.StreamInput;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.io.stream.StreamOutput;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ToXContent;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentBuilder;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.AggregationBuilder;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.AggregatorFactory;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.PipelineAggregationBuilder;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.bucket.histogram.AutoDateHistogramAggregatorFactory;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramAggregatorFactory;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.bucket.histogram.HistogramAggregatorFactory;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;

public abstract class AbstractPipelineAggregationBuilder<PAB extends AbstractPipelineAggregationBuilder<PAB>>
extends PipelineAggregationBuilder {
    public static final ParseField BUCKETS_PATH_FIELD = new ParseField("buckets_path", new String[0]);
    protected final String type;
    protected Map<String, Object> metaData;

    protected AbstractPipelineAggregationBuilder(String name, String type, String[] bucketsPaths) {
        super(name, bucketsPaths);
        if (type == null) {
            throw new IllegalArgumentException("[type] must not be null: [" + name + "]");
        }
        this.type = type;
    }

    protected AbstractPipelineAggregationBuilder(StreamInput in, String type) throws IOException {
        this(in.readString(), type, in.readStringArray());
        this.metaData = in.readMap();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.name);
        out.writeStringArray(this.bucketsPaths);
        out.writeMap(this.metaData);
        this.doWriteTo(out);
    }

    protected abstract void doWriteTo(StreamOutput var1) throws IOException;

    public String type() {
        return this.type;
    }

    @Override
    public final void validate(AggregatorFactory<?> parent, Collection<AggregationBuilder> factories, Collection<PipelineAggregationBuilder> pipelineAggregatorFactories) {
        this.doValidate(parent, factories, pipelineAggregatorFactories);
    }

    protected abstract PipelineAggregator createInternal(Map<String, Object> var1);

    @Override
    public final PipelineAggregator create() {
        PipelineAggregator aggregator = this.createInternal(this.metaData);
        return aggregator;
    }

    public void doValidate(AggregatorFactory<?> parent, Collection<AggregationBuilder> factories, Collection<PipelineAggregationBuilder> pipelineAggregatorFactories) {
    }

    public static void validateSequentiallyOrderedParentAggs(AggregatorFactory<?> parent, String type, String name) {
        HistogramAggregatorFactory histoParent;
        if (!(parent instanceof HistogramAggregatorFactory || parent instanceof DateHistogramAggregatorFactory || parent instanceof AutoDateHistogramAggregatorFactory)) {
            throw new IllegalStateException(type + " aggregation [" + name + "] must have a histogram, date_histogram or auto_date_histogram as parent");
        }
        if (parent instanceof HistogramAggregatorFactory ? (histoParent = (HistogramAggregatorFactory)parent).minDocCount() != 0L : parent instanceof DateHistogramAggregatorFactory && (histoParent = (DateHistogramAggregatorFactory)parent).minDocCount() != 0L) {
            throw new IllegalStateException("parent histogram of " + type + " aggregation [" + name + "] must have min_doc_count of 0");
        }
    }

    public PAB setMetaData(Map<String, Object> metaData) {
        this.metaData = metaData;
        return (PAB)this;
    }

    @Override
    public final XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(this.getName());
        if (this.metaData != null) {
            builder.field("meta", this.metaData);
        }
        builder.startObject(this.type);
        if (!this.overrideBucketsPath() && this.bucketsPaths != null) {
            builder.startArray(PipelineAggregator.Parser.BUCKETS_PATH.getPreferredName());
            for (String path : this.bucketsPaths) {
                builder.value(path);
            }
            builder.endArray();
        }
        this.internalXContent(builder, params);
        builder.endObject();
        return builder.endObject();
    }

    protected boolean overrideBucketsPath() {
        return false;
    }

    protected abstract XContentBuilder internalXContent(XContentBuilder var1, ToXContent.Params var2) throws IOException;

    public int hashCode() {
        return Objects.hash(Arrays.hashCode(this.bucketsPaths), this.metaData, this.name, this.type);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractPipelineAggregationBuilder other = (AbstractPipelineAggregationBuilder)obj;
        return Objects.equals(this.type, other.type) && Objects.equals(this.name, other.name) && Objects.equals(this.metaData, other.metaData) && Objects.deepEquals(this.bucketsPaths, other.bucketsPaths);
    }

    @Override
    public String getType() {
        return this.type;
    }
}

