/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.metrics;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.io.stream.StreamInput;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.io.stream.StreamOutput;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ToXContent;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentBuilder;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.DocValueFormat;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.Aggregation;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.InternalAggregation;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.metrics.InternalNumericMetricsAggregation;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.metrics.Sum;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;

public class InternalSum
extends InternalNumericMetricsAggregation.SingleValue
implements Sum {
    private final double sum;

    InternalSum(String name, double sum, DocValueFormat formatter, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) {
        super(name, pipelineAggregators, metaData);
        this.sum = sum;
        this.format = formatter;
    }

    public InternalSum(StreamInput in) throws IOException {
        super(in);
        this.format = in.readNamedWriteable(DocValueFormat.class);
        this.sum = in.readDouble();
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeNamedWriteable(this.format);
        out.writeDouble(this.sum);
    }

    @Override
    public String getWriteableName() {
        return "sum";
    }

    @Override
    public double value() {
        return this.sum;
    }

    @Override
    public double getValue() {
        return this.sum;
    }

    @Override
    public InternalSum doReduce(List<InternalAggregation> aggregations, InternalAggregation.ReduceContext reduceContext) {
        double sum = 0.0;
        double compensation = 0.0;
        for (InternalAggregation aggregation : aggregations) {
            double value = ((InternalSum)aggregation).sum;
            if (!Double.isFinite(value)) {
                sum += value;
                continue;
            }
            if (!Double.isFinite(sum)) continue;
            double corrected = value - compensation;
            double newSum = sum + corrected;
            compensation = newSum - sum - corrected;
            sum = newSum;
        }
        return new InternalSum(this.name, sum, this.format, this.pipelineAggregators(), this.getMetaData());
    }

    @Override
    public XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field(Aggregation.CommonFields.VALUE.getPreferredName(), this.sum);
        if (this.format != DocValueFormat.RAW) {
            builder.field(Aggregation.CommonFields.VALUE_AS_STRING.getPreferredName(), this.format.format(this.sum).toString());
        }
        return builder;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.sum);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        InternalSum that = (InternalSum)obj;
        return Objects.equals(this.sum, that.sum);
    }
}

