/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.bucket.terms;

import java.io.IOException;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ObjectParser;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentBuilder;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentParser;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.Aggregation;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.bucket.terms.ParsedTerms;

public class ParsedLongTerms
extends ParsedTerms {
    private static ObjectParser<ParsedLongTerms, Void> PARSER = new ObjectParser(ParsedLongTerms.class.getSimpleName(), true, ParsedLongTerms::new);

    @Override
    public String getType() {
        return "lterms";
    }

    public static ParsedLongTerms fromXContent(XContentParser parser, String name) throws IOException {
        ParsedLongTerms aggregation = PARSER.parse(parser, null);
        aggregation.setName(name);
        return aggregation;
    }

    static {
        ParsedLongTerms.declareParsedTermsFields(PARSER, ParsedBucket::fromXContent);
    }

    public static class ParsedBucket
    extends ParsedTerms.ParsedBucket {
        private Long key;

        @Override
        public Object getKey() {
            return this.key;
        }

        @Override
        public String getKeyAsString() {
            String keyAsString = super.getKeyAsString();
            if (keyAsString != null) {
                return keyAsString;
            }
            if (this.key != null) {
                return Long.toString(this.key);
            }
            return null;
        }

        @Override
        public Number getKeyAsNumber() {
            return this.key;
        }

        @Override
        protected XContentBuilder keyToXContent(XContentBuilder builder) throws IOException {
            builder.field(Aggregation.CommonFields.KEY.getPreferredName(), this.key);
            if (super.getKeyAsString() != null) {
                builder.field(Aggregation.CommonFields.KEY_AS_STRING.getPreferredName(), this.getKeyAsString());
            }
            return builder;
        }

        static ParsedBucket fromXContent(XContentParser parser) throws IOException {
            return ParsedBucket.parseTermsBucketXContent(parser, ParsedBucket::new, (p, bucket) -> {
                bucket.key = p.longValue();
            });
        }
    }
}

