/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.bucket.terms;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.io.stream.StreamInput;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.io.stream.StreamOutput;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentBuilder;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.DocValueFormat;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.Aggregation;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.BucketOrder;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.InternalAggregation;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.InternalAggregations;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.bucket.terms.DoubleTerms;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.bucket.terms.InternalMappedTerms;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.bucket.terms.InternalTerms;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;

public class LongTerms
extends InternalMappedTerms<LongTerms, Bucket> {
    public static final String NAME = "lterms";

    public LongTerms(String name, BucketOrder order, int requiredSize, long minDocCount, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData, DocValueFormat format, int shardSize, boolean showTermDocCountError, long otherDocCount, List<Bucket> buckets, long docCountError) {
        super(name, order, requiredSize, minDocCount, pipelineAggregators, metaData, format, shardSize, showTermDocCountError, otherDocCount, buckets, docCountError);
    }

    public LongTerms(StreamInput in) throws IOException {
        super(in, Bucket::new);
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }

    @Override
    public LongTerms create(List<Bucket> buckets) {
        return new LongTerms(this.name, this.order, this.requiredSize, this.minDocCount, this.pipelineAggregators(), (Map<String, Object>)this.metaData, this.format, this.shardSize, this.showTermDocCountError, this.otherDocCount, buckets, this.docCountError);
    }

    @Override
    public Bucket createBucket(InternalAggregations aggregations, Bucket prototype) {
        return new Bucket(prototype.term, prototype.docCount, aggregations, prototype.showDocCountError, prototype.docCountError, prototype.format);
    }

    @Override
    protected LongTerms create(String name, List<Bucket> buckets, long docCountError, long otherDocCount) {
        return new LongTerms(name, this.order, this.requiredSize, this.minDocCount, this.pipelineAggregators(), this.getMetaData(), this.format, this.shardSize, this.showTermDocCountError, otherDocCount, buckets, docCountError);
    }

    protected Bucket[] createBucketsArray(int size) {
        return new Bucket[size];
    }

    @Override
    public InternalAggregation doReduce(List<InternalAggregation> aggregations, InternalAggregation.ReduceContext reduceContext) {
        for (InternalAggregation agg : aggregations) {
            if (!(agg instanceof DoubleTerms)) continue;
            return agg.doReduce(aggregations, reduceContext);
        }
        return super.doReduce(aggregations, reduceContext);
    }

    static DoubleTerms convertLongTermsToDouble(LongTerms longTerms, DocValueFormat decimalFormat) {
        List buckets = longTerms.getBuckets();
        ArrayList<DoubleTerms.Bucket> newBuckets = new ArrayList<DoubleTerms.Bucket>();
        for (Terms.Bucket bucket : buckets) {
            newBuckets.add(new DoubleTerms.Bucket(bucket.getKeyAsNumber().doubleValue(), bucket.getDocCount(), (InternalAggregations)bucket.getAggregations(), longTerms.showTermDocCountError, longTerms.showTermDocCountError ? bucket.getDocCountError() : 0L, decimalFormat));
        }
        return new DoubleTerms(longTerms.getName(), longTerms.order, longTerms.requiredSize, longTerms.minDocCount, longTerms.pipelineAggregators(), (Map<String, Object>)longTerms.metaData, longTerms.format, longTerms.shardSize, longTerms.showTermDocCountError, longTerms.otherDocCount, (List<DoubleTerms.Bucket>)newBuckets, longTerms.docCountError);
    }

    public static class Bucket
    extends InternalTerms.Bucket<Bucket> {
        long term;

        public Bucket(long term, long docCount, InternalAggregations aggregations, boolean showDocCountError, long docCountError, DocValueFormat format) {
            super(docCount, aggregations, showDocCountError, docCountError, format);
            this.term = term;
        }

        public Bucket(StreamInput in, DocValueFormat format, boolean showDocCountError) throws IOException {
            super(in, format, showDocCountError);
            this.term = in.readLong();
        }

        @Override
        protected void writeTermTo(StreamOutput out) throws IOException {
            out.writeLong(this.term);
        }

        @Override
        public String getKeyAsString() {
            return this.format.format(this.term).toString();
        }

        @Override
        public Object getKey() {
            return this.term;
        }

        @Override
        public Number getKeyAsNumber() {
            return this.term;
        }

        @Override
        public int compareKey(Bucket other) {
            return Long.compare(this.term, other.term);
        }

        @Override
        Bucket newBucket(long docCount, InternalAggregations aggs, long docCountError) {
            return new Bucket(this.term, docCount, aggs, this.showDocCountError, docCountError, this.format);
        }

        @Override
        protected final XContentBuilder keyToXContent(XContentBuilder builder) throws IOException {
            builder.field(Aggregation.CommonFields.KEY.getPreferredName(), this.term);
            if (this.format != DocValueFormat.RAW) {
                builder.field(Aggregation.CommonFields.KEY_AS_STRING.getPreferredName(), this.format.format(this.term).toString());
            }
            return builder;
        }

        @Override
        public boolean equals(Object obj) {
            return super.equals(obj) && Objects.equals(this.term, ((Bucket)obj).term);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.term);
        }
    }
}

