/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.bucket.significant.heuristics;

import java.io.IOException;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.io.stream.StreamInput;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ToXContent;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentBuilder;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.bucket.significant.heuristics.NXYSignificanceHeuristic;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.bucket.significant.heuristics.SignificanceHeuristic;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.bucket.significant.heuristics.SignificanceHeuristicParser;

public class MutualInformation
extends NXYSignificanceHeuristic {
    public static final String NAME = "mutual_information";
    private static final double log2 = Math.log(2.0);
    public static final SignificanceHeuristicParser PARSER = new NXYSignificanceHeuristic.NXYParser(){

        @Override
        protected SignificanceHeuristic newHeuristic(boolean includeNegatives, boolean backgroundIsSuperset) {
            return new MutualInformation(includeNegatives, backgroundIsSuperset);
        }
    };

    public MutualInformation(boolean includeNegatives, boolean backgroundIsSuperset) {
        super(includeNegatives, backgroundIsSuperset);
    }

    public MutualInformation(StreamInput in) throws IOException {
        super(in);
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof MutualInformation)) {
            return false;
        }
        return super.equals(other);
    }

    @Override
    public int hashCode() {
        int result = NAME.hashCode();
        result = 31 * result + super.hashCode();
        return result;
    }

    @Override
    public double getScore(long subsetFreq, long subsetSize, long supersetFreq, long supersetSize) {
        NXYSignificanceHeuristic.Frequencies frequencies = this.computeNxys(subsetFreq, subsetSize, supersetFreq, supersetSize, "MutualInformation");
        double score = (this.getMITerm(frequencies.N00, frequencies.N0_, frequencies.N_0, frequencies.N) + this.getMITerm(frequencies.N01, frequencies.N0_, frequencies.N_1, frequencies.N) + this.getMITerm(frequencies.N10, frequencies.N1_, frequencies.N_0, frequencies.N) + this.getMITerm(frequencies.N11, frequencies.N1_, frequencies.N_1, frequencies.N)) / log2;
        if (Double.isNaN(score)) {
            score = Double.NEGATIVE_INFINITY;
        }
        if (!this.includeNegatives && frequencies.N11 / frequencies.N_1 < frequencies.N10 / frequencies.N_0) {
            score = Double.NEGATIVE_INFINITY;
        }
        return score;
    }

    double getMITerm(double Nxy, double Nx_, double N_y, double N) {
        double numerator = Math.abs(N * Nxy);
        double denominator = Math.abs(Nx_ * N_y);
        double factor = Math.abs(Nxy / N);
        if (numerator < 1.0E-7 && factor < 1.0E-7) {
            return 0.0;
        }
        return factor * Math.log(numerator / denominator);
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(NAME);
        super.build(builder);
        builder.endObject();
        return builder;
    }

    public static class MutualInformationBuilder
    extends NXYSignificanceHeuristic.NXYBuilder {
        public MutualInformationBuilder(boolean includeNegatives, boolean backgroundIsSuperset) {
            super(includeNegatives, backgroundIsSuperset);
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject(MutualInformation.NAME);
            super.build(builder);
            builder.endObject();
            return builder;
        }
    }
}

