/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.bucket.range;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.Version;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.io.stream.StreamInput;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.io.stream.StreamOutput;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ToXContent;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentBuilder;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.DocValueFormat;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.Aggregation;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.Aggregations;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.InternalAggregation;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.InternalAggregations;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.InternalMultiBucketAggregation;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.bucket.range.Range;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.support.ValueType;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.support.ValuesSourceType;

public class InternalRange<B extends Bucket, R extends InternalRange<B, R>>
extends InternalMultiBucketAggregation<R, B>
implements Range {
    static final Factory FACTORY = new Factory();
    private final List<B> ranges;
    protected final DocValueFormat format;
    protected final boolean keyed;

    public InternalRange(String name, List<B> ranges, DocValueFormat format, boolean keyed, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) {
        super(name, pipelineAggregators, metaData);
        this.ranges = ranges;
        this.format = format;
        this.keyed = keyed;
    }

    public InternalRange(StreamInput in) throws IOException {
        super(in);
        this.format = in.readNamedWriteable(DocValueFormat.class);
        this.keyed = in.readBoolean();
        int size = in.readVInt();
        ArrayList<B> ranges = new ArrayList<B>(size);
        for (int i = 0; i < size; ++i) {
            String key = in.getVersion().onOrAfter(Version.V_6_4_0) ? in.readString() : in.readOptionalString();
            ranges.add(this.getFactory().createBucket(key, in.readDouble(), in.readDouble(), in.readVLong(), new InternalAggregations(in), this.keyed, this.format));
        }
        this.ranges = ranges;
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeNamedWriteable(this.format);
        out.writeBoolean(this.keyed);
        out.writeVInt(this.ranges.size());
        for (Bucket bucket : this.ranges) {
            bucket.writeTo(out);
        }
    }

    @Override
    public String getWriteableName() {
        return "range";
    }

    @Override
    public List<B> getBuckets() {
        return this.ranges;
    }

    public Factory<B, R> getFactory() {
        return FACTORY;
    }

    @Override
    public R create(List<B> buckets) {
        return (R)this.getFactory().create(buckets, this);
    }

    @Override
    public B createBucket(InternalAggregations aggregations, B prototype) {
        return this.getFactory().createBucket(aggregations, prototype);
    }

    @Override
    public InternalAggregation doReduce(List<InternalAggregation> aggregations, InternalAggregation.ReduceContext reduceContext) {
        reduceContext.consumeBucketsAndMaybeBreak(this.ranges.size());
        List[] rangeList = new List[this.ranges.size()];
        for (int i = 0; i < rangeList.length; ++i) {
            rangeList[i] = new ArrayList();
        }
        for (InternalAggregation aggregation : aggregations) {
            InternalRange ranges = (InternalRange)aggregation;
            int i = 0;
            for (Bucket range : ranges.ranges) {
                rangeList[i++].add(range);
            }
        }
        ArrayList<Bucket> ranges = new ArrayList<Bucket>();
        for (int i = 0; i < this.ranges.size(); ++i) {
            ranges.add(((Bucket)rangeList[i].get(0)).reduce(rangeList[i], reduceContext));
        }
        return this.getFactory().create(this.name, ranges, this.format, this.keyed, this.pipelineAggregators(), this.getMetaData());
    }

    @Override
    public XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.keyed) {
            builder.startObject(Aggregation.CommonFields.BUCKETS.getPreferredName());
        } else {
            builder.startArray(Aggregation.CommonFields.BUCKETS.getPreferredName());
        }
        for (Bucket range : this.ranges) {
            range.toXContent(builder, params);
        }
        if (this.keyed) {
            builder.endObject();
        } else {
            builder.endArray();
        }
        return builder;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.ranges, this.format, this.keyed);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        InternalRange that = (InternalRange)obj;
        return Objects.equals(this.ranges, that.ranges) && Objects.equals(this.format, that.format) && Objects.equals(this.keyed, that.keyed);
    }

    public static class Factory<B extends Bucket, R extends InternalRange<B, R>> {
        public ValuesSourceType getValueSourceType() {
            return ValuesSourceType.NUMERIC;
        }

        public ValueType getValueType() {
            return ValueType.NUMERIC;
        }

        public R create(String name, List<B> ranges, DocValueFormat format, boolean keyed, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) {
            return (R)new InternalRange(name, ranges, format, keyed, pipelineAggregators, metaData);
        }

        public B createBucket(String key, double from, double to, long docCount, InternalAggregations aggregations, boolean keyed, DocValueFormat format) {
            return (B)new Bucket(key, from, to, docCount, aggregations, keyed, format);
        }

        public R create(List<B> ranges, R prototype) {
            return (R)new InternalRange(((InternalRange)prototype).name, ranges, ((InternalRange)prototype).format, ((InternalRange)prototype).keyed, ((InternalAggregation)prototype).pipelineAggregators(), ((InternalRange)prototype).metaData);
        }

        public B createBucket(InternalAggregations aggregations, B prototype) {
            return (B)new Bucket(((Bucket)prototype).getKey(), ((Bucket)prototype).from, ((Bucket)prototype).to, ((Bucket)prototype).getDocCount(), aggregations, ((Bucket)prototype).keyed, ((Bucket)prototype).format);
        }
    }

    public static class Bucket
    extends InternalMultiBucketAggregation.InternalBucket
    implements Range.Bucket {
        protected final transient boolean keyed;
        protected final transient DocValueFormat format;
        protected final double from;
        protected final double to;
        private final long docCount;
        private final InternalAggregations aggregations;
        private final String key;

        public Bucket(String key, double from, double to, long docCount, InternalAggregations aggregations, boolean keyed, DocValueFormat format) {
            this.keyed = keyed;
            this.format = format;
            this.key = key != null ? key : Bucket.generateKey(from, to, format);
            this.from = from;
            this.to = to;
            this.docCount = docCount;
            this.aggregations = aggregations;
        }

        @Override
        public String getKey() {
            return this.getKeyAsString();
        }

        @Override
        public String getKeyAsString() {
            return this.key;
        }

        @Override
        public Object getFrom() {
            return this.from;
        }

        @Override
        public Object getTo() {
            return this.to;
        }

        public boolean getKeyed() {
            return this.keyed;
        }

        public DocValueFormat getFormat() {
            return this.format;
        }

        @Override
        public String getFromAsString() {
            if (Double.isInfinite(this.from)) {
                return null;
            }
            return this.format.format(this.from).toString();
        }

        @Override
        public String getToAsString() {
            if (Double.isInfinite(this.to)) {
                return null;
            }
            return this.format.format(this.to).toString();
        }

        @Override
        public long getDocCount() {
            return this.docCount;
        }

        @Override
        public Aggregations getAggregations() {
            return this.aggregations;
        }

        protected Factory<? extends Bucket, ?> getFactory() {
            return FACTORY;
        }

        Bucket reduce(List<Bucket> ranges, InternalAggregation.ReduceContext context) {
            long docCount = 0L;
            ArrayList<InternalAggregations> aggregationsList = new ArrayList<InternalAggregations>(ranges.size());
            for (Bucket range : ranges) {
                docCount += range.docCount;
                aggregationsList.add(range.aggregations);
            }
            InternalAggregations aggs = InternalAggregations.reduce(aggregationsList, context);
            return this.getFactory().createBucket(this.key, this.from, this.to, docCount, aggs, this.keyed, this.format);
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            if (this.keyed) {
                builder.startObject(this.key);
            } else {
                builder.startObject();
                builder.field(Aggregation.CommonFields.KEY.getPreferredName(), this.key);
            }
            if (!Double.isInfinite(this.from)) {
                builder.field(Aggregation.CommonFields.FROM.getPreferredName(), this.from);
                if (this.format != DocValueFormat.RAW) {
                    builder.field(Aggregation.CommonFields.FROM_AS_STRING.getPreferredName(), this.format.format(this.from));
                }
            }
            if (!Double.isInfinite(this.to)) {
                builder.field(Aggregation.CommonFields.TO.getPreferredName(), this.to);
                if (this.format != DocValueFormat.RAW) {
                    builder.field(Aggregation.CommonFields.TO_AS_STRING.getPreferredName(), this.format.format(this.to));
                }
            }
            builder.field(Aggregation.CommonFields.DOC_COUNT.getPreferredName(), this.docCount);
            this.aggregations.toXContentInternal(builder, params);
            builder.endObject();
            return builder;
        }

        private static String generateKey(double from, double to, DocValueFormat format) {
            StringBuilder builder = new StringBuilder().append(Double.isInfinite(from) ? "*" : format.format(from)).append("-").append(Double.isInfinite(to) ? "*" : format.format(to));
            return builder.toString();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            if (out.getVersion().onOrAfter(Version.V_6_4_0)) {
                out.writeString(this.key);
            } else {
                out.writeOptionalString(this.key);
            }
            out.writeDouble(this.from);
            out.writeDouble(this.to);
            out.writeVLong(this.docCount);
            this.aggregations.writeTo(out);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            Bucket that = (Bucket)other;
            return Objects.equals(this.from, that.from) && Objects.equals(this.to, that.to) && Objects.equals(this.docCount, that.docCount) && Objects.equals(this.aggregations, that.aggregations) && Objects.equals(this.key, that.key);
        }

        public int hashCode() {
            return Objects.hash(this.getClass(), this.from, this.to, this.docCount, this.aggregations, this.key);
        }
    }
}

