/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.bucket.range;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.ParseField;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.ParsingException;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.geo.GeoDistance;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.geo.GeoPoint;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.io.stream.StreamInput;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.io.stream.StreamOutput;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.unit.DistanceUnit;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ObjectParser;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ToXContent;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentBuilder;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentParser;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentParserUtils;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.AggregationBuilder;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.AggregatorFactories;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.AggregatorFactory;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.bucket.range.GeoDistanceRangeAggregatorFactory;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.bucket.range.InternalGeoDistance;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.bucket.range.InternalRange;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.bucket.range.RangeAggregator;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.support.ValuesSource;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.support.ValuesSourceAggregationBuilder;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.support.ValuesSourceAggregatorFactory;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.support.ValuesSourceParserHelper;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.internal.SearchContext;

public class GeoDistanceAggregationBuilder
extends ValuesSourceAggregationBuilder<ValuesSource.GeoPoint, GeoDistanceAggregationBuilder> {
    public static final String NAME = "geo_distance";
    static final ParseField ORIGIN_FIELD = new ParseField("origin", "center", "point", "por");
    static final ParseField UNIT_FIELD = new ParseField("unit", new String[0]);
    static final ParseField DISTANCE_TYPE_FIELD = new ParseField("distance_type", new String[0]);
    private static final ObjectParser<GeoDistanceAggregationBuilder, Void> PARSER = new ObjectParser("geo_distance");
    private GeoPoint origin;
    private List<Range> ranges = new ArrayList<Range>();
    private DistanceUnit unit = DistanceUnit.DEFAULT;
    private GeoDistance distanceType = GeoDistance.ARC;
    private boolean keyed = false;

    public static AggregationBuilder parse(String aggregationName, XContentParser parser) throws IOException {
        GeoDistanceAggregationBuilder builder = PARSER.parse(parser, new GeoDistanceAggregationBuilder(aggregationName), null);
        if (builder.origin() == null) {
            throw new IllegalArgumentException("Aggregation [" + aggregationName + "] must define an [origin].");
        }
        return builder;
    }

    private static GeoPoint parseGeoPoint(XContentParser parser) throws IOException {
        XContentParser.Token token = parser.currentToken();
        if (token == XContentParser.Token.VALUE_STRING) {
            GeoPoint point = new GeoPoint();
            point.resetFromString(parser.text());
            return point;
        }
        if (token == XContentParser.Token.START_ARRAY) {
            double lat = Double.NaN;
            double lon = Double.NaN;
            while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                if (Double.isNaN(lon)) {
                    lon = parser.doubleValue();
                    continue;
                }
                if (Double.isNaN(lat)) {
                    lat = parser.doubleValue();
                    continue;
                }
                throw new ParsingException(parser.getTokenLocation(), "malformed [" + ORIGIN_FIELD.getPreferredName() + "]: a geo point array must be of the form [lon, lat]", new Object[0]);
            }
            return new GeoPoint(lat, lon);
        }
        if (token == XContentParser.Token.START_OBJECT) {
            String currentFieldName = null;
            double lat = Double.NaN;
            double lon = Double.NaN;
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    currentFieldName = parser.currentName();
                    continue;
                }
                if (token != XContentParser.Token.VALUE_NUMBER) continue;
                if ("lat".equals(currentFieldName)) {
                    lat = parser.doubleValue();
                    continue;
                }
                if (!"lon".equals(currentFieldName)) continue;
                lon = parser.doubleValue();
            }
            if (Double.isNaN(lat) || Double.isNaN(lon)) {
                throw new ParsingException(parser.getTokenLocation(), "malformed [" + currentFieldName + "] geo point object. either [lat] or [lon] (or both) are missing", new Object[0]);
            }
            return new GeoPoint(lat, lon);
        }
        throw new IllegalArgumentException("Unexpected token [" + (Object)((Object)token) + "] while parsing geo point");
    }

    private static Range parseRange(XContentParser parser) throws IOException {
        XContentParser.Token token;
        String fromAsStr = null;
        String toAsStr = null;
        double from = 0.0;
        double to = Double.POSITIVE_INFINITY;
        String key = null;
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.VALUE_NUMBER) {
                if (RangeAggregator.Range.FROM_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    from = parser.doubleValue();
                    continue;
                }
                if (RangeAggregator.Range.TO_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    to = parser.doubleValue();
                    continue;
                }
                XContentParserUtils.throwUnknownField(currentFieldName, parser.getTokenLocation());
                continue;
            }
            if (token == XContentParser.Token.VALUE_STRING) {
                if (RangeAggregator.Range.KEY_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    key = parser.text();
                    continue;
                }
                if (RangeAggregator.Range.FROM_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    fromAsStr = parser.text();
                    continue;
                }
                if (RangeAggregator.Range.TO_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    toAsStr = parser.text();
                    continue;
                }
                XContentParserUtils.throwUnknownField(currentFieldName, parser.getTokenLocation());
                continue;
            }
            if (token == XContentParser.Token.VALUE_NULL) {
                if (RangeAggregator.Range.FROM_FIELD.match(currentFieldName, parser.getDeprecationHandler()) || RangeAggregator.Range.TO_FIELD.match(currentFieldName, parser.getDeprecationHandler()) || RangeAggregator.Range.KEY_FIELD.match(currentFieldName, parser.getDeprecationHandler())) continue;
                XContentParserUtils.throwUnknownField(currentFieldName, parser.getTokenLocation());
                continue;
            }
            XContentParserUtils.throwUnknownToken(token, parser.getTokenLocation());
        }
        if (fromAsStr != null || toAsStr != null) {
            return new Range(key, Double.parseDouble(fromAsStr), Double.parseDouble(toAsStr));
        }
        return new Range(key, from, to);
    }

    public GeoDistanceAggregationBuilder(String name, GeoPoint origin) {
        this(name, origin, InternalGeoDistance.FACTORY);
        if (origin == null) {
            throw new IllegalArgumentException("[origin] must not be null: [" + name + "]");
        }
    }

    private GeoDistanceAggregationBuilder(String name, GeoPoint origin, InternalRange.Factory<InternalGeoDistance.Bucket, InternalGeoDistance> rangeFactory) {
        super(name, rangeFactory.getValueSourceType(), rangeFactory.getValueType());
        this.origin = origin;
    }

    public GeoDistanceAggregationBuilder(StreamInput in) throws IOException {
        super(in, InternalGeoDistance.FACTORY.getValueSourceType(), InternalGeoDistance.FACTORY.getValueType());
        this.origin = new GeoPoint(in.readDouble(), in.readDouble());
        int size = in.readVInt();
        this.ranges = new ArrayList<Range>(size);
        for (int i = 0; i < size; ++i) {
            this.ranges.add(new Range(in));
        }
        this.keyed = in.readBoolean();
        this.distanceType = GeoDistance.readFromStream(in);
        this.unit = DistanceUnit.readFromStream(in);
    }

    GeoDistanceAggregationBuilder(String name) {
        this(name, null, InternalGeoDistance.FACTORY);
    }

    protected GeoDistanceAggregationBuilder(GeoDistanceAggregationBuilder clone, AggregatorFactories.Builder factoriesBuilder, Map<String, Object> metaData) {
        super(clone, factoriesBuilder, metaData);
        this.origin = clone.origin;
        this.distanceType = clone.distanceType;
        this.unit = clone.unit;
        this.keyed = clone.keyed;
        this.ranges = new ArrayList<Range>(clone.ranges);
    }

    @Override
    protected AggregationBuilder shallowCopy(AggregatorFactories.Builder factoriesBuilder, Map<String, Object> metaData) {
        return new GeoDistanceAggregationBuilder(this, factoriesBuilder, metaData);
    }

    GeoDistanceAggregationBuilder origin(GeoPoint origin) {
        this.origin = origin;
        return this;
    }

    public GeoPoint origin() {
        return this.origin;
    }

    @Override
    protected void innerWriteTo(StreamOutput out) throws IOException {
        out.writeDouble(this.origin.lat());
        out.writeDouble(this.origin.lon());
        out.writeVInt(this.ranges.size());
        for (Range range : this.ranges) {
            range.writeTo(out);
        }
        out.writeBoolean(this.keyed);
        this.distanceType.writeTo(out);
        this.unit.writeTo(out);
    }

    public GeoDistanceAggregationBuilder addRange(Range range) {
        if (range == null) {
            throw new IllegalArgumentException("[range] must not be null: [" + this.name + "]");
        }
        this.ranges.add(range);
        return this;
    }

    public GeoDistanceAggregationBuilder addRange(String key, double from, double to) {
        this.ranges.add(new Range(key, from, to));
        return this;
    }

    public GeoDistanceAggregationBuilder addRange(double from, double to) {
        return this.addRange(null, from, to);
    }

    public GeoDistanceAggregationBuilder addUnboundedTo(String key, double to) {
        this.ranges.add(new Range(key, null, to));
        return this;
    }

    public GeoDistanceAggregationBuilder addUnboundedTo(double to) {
        return this.addUnboundedTo(null, to);
    }

    public GeoDistanceAggregationBuilder addUnboundedFrom(String key, double from) {
        this.addRange(new Range(key, from, null));
        return this;
    }

    public GeoDistanceAggregationBuilder addUnboundedFrom(double from) {
        return this.addUnboundedFrom(null, from);
    }

    public List<Range> range() {
        return this.ranges;
    }

    @Override
    public String getType() {
        return NAME;
    }

    public GeoDistanceAggregationBuilder unit(DistanceUnit unit) {
        if (unit == null) {
            throw new IllegalArgumentException("[unit] must not be null: [" + this.name + "]");
        }
        this.unit = unit;
        return this;
    }

    public DistanceUnit unit() {
        return this.unit;
    }

    public GeoDistanceAggregationBuilder distanceType(GeoDistance distanceType) {
        if (distanceType == null) {
            throw new IllegalArgumentException("[distanceType] must not be null: [" + this.name + "]");
        }
        this.distanceType = distanceType;
        return this;
    }

    public GeoDistance distanceType() {
        return this.distanceType;
    }

    public GeoDistanceAggregationBuilder keyed(boolean keyed) {
        this.keyed = keyed;
        return this;
    }

    public boolean keyed() {
        return this.keyed;
    }

    @Override
    protected ValuesSourceAggregatorFactory<ValuesSource.GeoPoint, ?> innerBuild(SearchContext context, ValuesSourceConfig<ValuesSource.GeoPoint> config, AggregatorFactory<?> parent, AggregatorFactories.Builder subFactoriesBuilder) throws IOException {
        Range[] ranges = this.ranges.toArray(new Range[this.range().size()]);
        if (ranges.length == 0) {
            throw new IllegalArgumentException("No [ranges] specified for the [" + this.getName() + "] aggregation");
        }
        return new GeoDistanceRangeAggregatorFactory(this.name, config, this.origin, ranges, this.unit, this.distanceType, this.keyed, context, parent, subFactoriesBuilder, this.metaData);
    }

    @Override
    protected XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field(ORIGIN_FIELD.getPreferredName(), this.origin);
        builder.field(RangeAggregator.RANGES_FIELD.getPreferredName(), this.ranges);
        builder.field(RangeAggregator.KEYED_FIELD.getPreferredName(), this.keyed);
        builder.field(UNIT_FIELD.getPreferredName(), this.unit);
        builder.field(DISTANCE_TYPE_FIELD.getPreferredName(), this.distanceType);
        return builder;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.origin, this.ranges, this.keyed, this.distanceType, this.unit);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        GeoDistanceAggregationBuilder other = (GeoDistanceAggregationBuilder)obj;
        return Objects.equals(this.origin, other.origin) && Objects.equals(this.ranges, other.ranges) && Objects.equals(this.keyed, other.keyed) && Objects.equals(this.distanceType, other.distanceType) && Objects.equals(this.unit, other.unit);
    }

    static {
        ValuesSourceParserHelper.declareGeoFields(PARSER, true, false);
        PARSER.declareBoolean(GeoDistanceAggregationBuilder::keyed, RangeAggregator.KEYED_FIELD);
        PARSER.declareObjectArray((agg, ranges) -> {
            for (Range range : ranges) {
                agg.addRange(range);
            }
        }, (p, c) -> GeoDistanceAggregationBuilder.parseRange(p), RangeAggregator.RANGES_FIELD);
        PARSER.declareField(GeoDistanceAggregationBuilder::unit, p -> DistanceUnit.fromString(p.text()), UNIT_FIELD, ObjectParser.ValueType.STRING);
        PARSER.declareField(GeoDistanceAggregationBuilder::distanceType, p -> GeoDistance.fromString(p.text()), DISTANCE_TYPE_FIELD, ObjectParser.ValueType.STRING);
        PARSER.declareField(GeoDistanceAggregationBuilder::origin, GeoDistanceAggregationBuilder::parseGeoPoint, ORIGIN_FIELD, ObjectParser.ValueType.OBJECT_ARRAY_OR_STRING);
    }

    public static class Range
    extends RangeAggregator.Range {
        public Range(String key, Double from, Double to) {
            super(Range.key(key, from, to), from == null ? 0.0 : from, to);
        }

        public Range(StreamInput in) throws IOException {
            super(in.readOptionalString(), in.readDouble(), in.readDouble());
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeOptionalString(this.key);
            out.writeDouble(this.from);
            out.writeDouble(this.to);
        }

        private static String key(String key, Double from, Double to) {
            if (key != null) {
                return key;
            }
            StringBuilder sb = new StringBuilder();
            sb.append(from == null || from == 0.0 ? "*" : from);
            sb.append("-");
            sb.append(to == null || Double.isInfinite(to) ? "*" : to);
            return sb.toString();
        }
    }
}

