/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.bucket.geogrid;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.io.stream.StreamInput;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.io.stream.StreamOutput;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.io.stream.Writeable;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.util.LongObjectPagedHashMap;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ToXContent;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentBuilder;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.Aggregation;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.InternalAggregation;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.InternalMultiBucketAggregation;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.bucket.geogrid.BucketPriorityQueue;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.bucket.geogrid.GeoGrid;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.bucket.geogrid.InternalGeoGridBucket;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;

public abstract class InternalGeoGrid<B extends InternalGeoGridBucket>
extends InternalMultiBucketAggregation<InternalGeoGrid, InternalGeoGridBucket>
implements GeoGrid {
    protected final int requiredSize;
    protected final List<InternalGeoGridBucket> buckets;

    InternalGeoGrid(String name, int requiredSize, List<InternalGeoGridBucket> buckets, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) {
        super(name, pipelineAggregators, metaData);
        this.requiredSize = requiredSize;
        this.buckets = buckets;
    }

    abstract Writeable.Reader<B> getBucketReader();

    public InternalGeoGrid(StreamInput in) throws IOException {
        super(in);
        this.requiredSize = InternalGeoGrid.readSize(in);
        this.buckets = in.readList(this.getBucketReader());
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        InternalGeoGrid.writeSize(this.requiredSize, out);
        out.writeList(this.buckets);
    }

    abstract InternalGeoGrid create(String var1, int var2, List<InternalGeoGridBucket> var3, List<PipelineAggregator> var4, Map<String, Object> var5);

    @Override
    public List<InternalGeoGridBucket> getBuckets() {
        return Collections.unmodifiableList(this.buckets);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public InternalGeoGrid doReduce(List<InternalAggregation> aggregations, InternalAggregation.ReduceContext reduceContext) {
        void var7_12;
        LongObjectPagedHashMap<ArrayList<InternalGeoGridBucket>> buckets = null;
        for (InternalAggregation aggregation : aggregations) {
            InternalGeoGrid grid = (InternalGeoGrid)aggregation;
            if (buckets == null) {
                buckets = new LongObjectPagedHashMap<ArrayList<InternalGeoGridBucket>>(grid.buckets.size(), reduceContext.bigArrays());
            }
            for (InternalGeoGridBucket obj : grid.buckets) {
                InternalGeoGridBucket bucket = obj;
                ArrayList<InternalGeoGridBucket> existingBuckets = (ArrayList<InternalGeoGridBucket>)buckets.get(bucket.hashAsLong());
                if (existingBuckets == null) {
                    existingBuckets = new ArrayList<InternalGeoGridBucket>(aggregations.size());
                    buckets.put(bucket.hashAsLong(), existingBuckets);
                }
                existingBuckets.add(bucket);
            }
        }
        int size = Math.toIntExact(!reduceContext.isFinalReduce() ? buckets.size() : Math.min((long)this.requiredSize, buckets.size()));
        BucketPriorityQueue ordered = new BucketPriorityQueue(size);
        for (LongObjectPagedHashMap.Cursor cursor : buckets) {
            List sameCellBuckets = (List)cursor.value;
            InternalGeoGridBucket removed = (InternalGeoGridBucket)ordered.insertWithOverflow(((InternalGeoGridBucket)sameCellBuckets.get(0)).reduce(sameCellBuckets, reduceContext));
            if (removed != null) {
                reduceContext.consumeBucketsAndMaybeBreak(-InternalGeoGrid.countInnerBucket(removed));
                continue;
            }
            reduceContext.consumeBucketsAndMaybeBreak(1);
        }
        buckets.close();
        InternalGeoGridBucket[] list = new InternalGeoGridBucket[ordered.size()];
        int n = ordered.size() - 1;
        while (var7_12 >= 0) {
            list[var7_12] = (InternalGeoGridBucket)ordered.pop();
            --var7_12;
        }
        return this.create(this.getName(), this.requiredSize, Arrays.asList(list), this.pipelineAggregators(), this.getMetaData());
    }

    @Override
    public XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startArray(Aggregation.CommonFields.BUCKETS.getPreferredName());
        for (InternalGeoGridBucket bucket : this.buckets) {
            bucket.toXContent(builder, params);
        }
        builder.endArray();
        return builder;
    }

    int getRequiredSize() {
        return this.requiredSize;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.requiredSize, this.buckets);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        InternalGeoGrid other = (InternalGeoGrid)obj;
        return Objects.equals(this.requiredSize, other.requiredSize) && Objects.equals(this.buckets, other.buckets);
    }
}

