/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.bucket.geogrid;

import java.io.IOException;
import java.util.Locale;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.ElasticsearchParseException;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.geo.GeoPoint;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.geo.GeoUtils;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentParser;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.support.XContentMapValues;

final class GeoTileUtils {
    static final int MAX_ZOOM = 29;
    private static final int ZOOM_SHIFT = 58;
    private static final long X_Y_VALUE_MASK = 0x1FFFFFFFL;

    private GeoTileUtils() {
    }

    static int parsePrecision(XContentParser parser) throws IOException, ElasticsearchParseException {
        Object node = parser.currentToken().equals((Object)XContentParser.Token.VALUE_NUMBER) ? Integer.valueOf(parser.intValue()) : parser.text();
        return XContentMapValues.nodeIntegerValue(node);
    }

    static int checkPrecisionRange(int precision) {
        if (precision < 0 || precision > 29) {
            throw new IllegalArgumentException("Invalid geotile_grid precision of " + precision + ". Must be between 0 and " + 29 + ".");
        }
        return precision;
    }

    static long longEncode(double longitude, double latitude, int precision) {
        long tiles = 1 << GeoTileUtils.checkPrecisionRange(precision);
        long xTile = (long)Math.floor((GeoUtils.normalizeLon(longitude) + 180.0) / 360.0 * (double)tiles);
        double latSin = Math.sin(Math.toRadians(GeoUtils.normalizeLat(latitude)));
        long yTile = (long)Math.floor((0.5 - Math.log((1.0 + latSin) / (1.0 - latSin)) / (Math.PI * 4)) * (double)tiles);
        if (xTile < 0L) {
            xTile = 0L;
        }
        if (xTile >= tiles) {
            xTile = tiles - 1L;
        }
        if (yTile < 0L) {
            yTile = 0L;
        }
        if (yTile >= tiles) {
            yTile = tiles - 1L;
        }
        return (long)precision << 58 | xTile << 29 | yTile;
    }

    private static int[] parseHash(long hash) {
        int zoom = (int)(hash >>> 58);
        int xTile = (int)(hash >>> 29 & 0x1FFFFFFFL);
        int yTile = (int)(hash & 0x1FFFFFFFL);
        return new int[]{zoom, xTile, yTile};
    }

    static String stringEncode(long hash) {
        int[] res = GeoTileUtils.parseHash(hash);
        GeoTileUtils.validateZXY(res[0], res[1], res[2]);
        return "" + res[0] + "/" + res[1] + "/" + res[2];
    }

    static GeoPoint hashToGeoPoint(long hash) {
        int[] res = GeoTileUtils.parseHash(hash);
        return GeoTileUtils.zxyToGeoPoint(res[0], res[1], res[2]);
    }

    static GeoPoint keyToGeoPoint(String hashAsString) {
        String[] parts = hashAsString.split("/", 4);
        if (parts.length != 3) {
            throw new IllegalArgumentException("Invalid geotile_grid hash string of " + hashAsString + ". Must be three integers in a form \"zoom/x/y\".");
        }
        try {
            return GeoTileUtils.zxyToGeoPoint(Integer.parseInt(parts[0]), Integer.parseInt(parts[1]), Integer.parseInt(parts[2]));
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid geotile_grid hash string of " + hashAsString + ". Must be three integers in a form \"zoom/x/y\".", e);
        }
    }

    private static int validateZXY(int zoom, int xTile, int yTile) {
        int tiles = 1 << GeoTileUtils.checkPrecisionRange(zoom);
        if (xTile < 0 || yTile < 0 || xTile >= tiles || yTile >= tiles) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Zoom/X/Y combination is not valid: %d/%d/%d", zoom, xTile, yTile));
        }
        return tiles;
    }

    private static GeoPoint zxyToGeoPoint(int zoom, int xTile, int yTile) {
        int tiles = GeoTileUtils.validateZXY(zoom, xTile, yTile);
        double n = Math.PI - Math.PI * 2 * ((double)yTile + 0.5) / (double)tiles;
        double lat = Math.toDegrees(Math.atan(Math.sinh(n)));
        double lon = ((double)xTile + 0.5) / (double)tiles * 360.0 - 180.0;
        return new GeoPoint(lat, lon);
    }
}

