/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.bucket.geogrid;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.Aggregator;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.AggregatorFactories;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.AggregatorFactory;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.InternalAggregation;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.NonCollectingAggregator;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.bucket.geogrid.CellIdSource;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.bucket.geogrid.GeoTileGridAggregator;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.bucket.geogrid.GeoTileUtils;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.bucket.geogrid.InternalGeoTileGrid;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.support.ValuesSource;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.support.ValuesSourceAggregatorFactory;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.internal.SearchContext;

public class GeoTileGridAggregatorFactory
extends ValuesSourceAggregatorFactory<ValuesSource.GeoPoint, GeoTileGridAggregatorFactory> {
    private final int precision;
    private final int requiredSize;
    private final int shardSize;

    GeoTileGridAggregatorFactory(String name, ValuesSourceConfig<ValuesSource.GeoPoint> config, int precision, int requiredSize, int shardSize, SearchContext context, AggregatorFactory<?> parent, AggregatorFactories.Builder subFactoriesBuilder, Map<String, Object> metaData) throws IOException {
        super(name, config, context, parent, subFactoriesBuilder, metaData);
        this.precision = precision;
        this.requiredSize = requiredSize;
        this.shardSize = shardSize;
    }

    @Override
    protected Aggregator createUnmapped(Aggregator parent, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) throws IOException {
        final InternalGeoTileGrid aggregation = new InternalGeoTileGrid(this.name, this.requiredSize, Collections.emptyList(), pipelineAggregators, metaData);
        return new NonCollectingAggregator(this.name, this.context, parent, pipelineAggregators, metaData){

            @Override
            public InternalAggregation buildEmptyAggregation() {
                return aggregation;
            }
        };
    }

    @Override
    protected Aggregator doCreateInternal(ValuesSource.GeoPoint valuesSource, Aggregator parent, boolean collectsFromSingleBucket, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) throws IOException {
        if (!collectsFromSingleBucket) {
            return GeoTileGridAggregatorFactory.asMultiBucketAggregator(this, this.context, parent);
        }
        CellIdSource cellIdSource = new CellIdSource(valuesSource, this.precision, GeoTileUtils::longEncode);
        return new GeoTileGridAggregator(this.name, this.factories, cellIdSource, this.requiredSize, this.shardSize, this.context, parent, pipelineAggregators, metaData);
    }
}

