/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.bucket.geogrid;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.LeafReaderContext;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.SortedNumericDocValues;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.ScoreMode;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.lease.Releasables;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.util.LongHash;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.Aggregator;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.AggregatorFactories;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.InternalAggregations;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.LeafBucketCollector;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.LeafBucketCollectorBase;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.bucket.BucketsAggregator;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.bucket.geogrid.BucketPriorityQueue;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.bucket.geogrid.CellIdSource;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.bucket.geogrid.InternalGeoGrid;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.bucket.geogrid.InternalGeoGridBucket;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.internal.SearchContext;

public abstract class GeoGridAggregator<T extends InternalGeoGrid>
extends BucketsAggregator {
    protected final int requiredSize;
    protected final int shardSize;
    protected final CellIdSource valuesSource;
    protected final LongHash bucketOrds;

    GeoGridAggregator(String name, AggregatorFactories factories, CellIdSource valuesSource, int requiredSize, int shardSize, SearchContext aggregationContext, Aggregator parent, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) throws IOException {
        super(name, factories, aggregationContext, parent, pipelineAggregators, metaData);
        this.valuesSource = valuesSource;
        this.requiredSize = requiredSize;
        this.shardSize = shardSize;
        this.bucketOrds = new LongHash(1L, aggregationContext.bigArrays());
    }

    @Override
    public ScoreMode scoreMode() {
        if (this.valuesSource != null && this.valuesSource.needsScores()) {
            return ScoreMode.COMPLETE;
        }
        return super.scoreMode();
    }

    @Override
    public LeafBucketCollector getLeafCollector(LeafReaderContext ctx, final LeafBucketCollector sub) throws IOException {
        final SortedNumericDocValues values = this.valuesSource.longValues(ctx);
        return new LeafBucketCollectorBase(sub, null){

            @Override
            public void collect(int doc, long bucket) throws IOException {
                assert (bucket == 0L);
                if (values.advanceExact(doc)) {
                    int valuesCount = values.docValueCount();
                    long previous = Long.MAX_VALUE;
                    for (int i = 0; i < valuesCount; ++i) {
                        long val = values.nextValue();
                        if (previous == val && i != 0) continue;
                        long bucketOrdinal = GeoGridAggregator.this.bucketOrds.add(val);
                        if (bucketOrdinal < 0L) {
                            bucketOrdinal = -1L - bucketOrdinal;
                            GeoGridAggregator.this.collectExistingBucket(sub, doc, bucketOrdinal);
                        } else {
                            GeoGridAggregator.this.collectBucket(sub, doc, bucketOrdinal);
                        }
                        previous = val;
                    }
                }
            }
        };
    }

    abstract T buildAggregation(String var1, int var2, List<InternalGeoGridBucket> var3, List<PipelineAggregator> var4, Map<String, Object> var5);

    abstract InternalGeoGridBucket newEmptyBucket();

    @Override
    public InternalGeoGrid buildAggregation(long owningBucketOrdinal) throws IOException {
        assert (owningBucketOrdinal == 0L);
        int size = (int)Math.min(this.bucketOrds.size(), (long)this.shardSize);
        this.consumeBucketsAndMaybeBreak(size);
        BucketPriorityQueue ordered = new BucketPriorityQueue(size);
        OrdinalBucket spare = null;
        long i = 0L;
        while (i < this.bucketOrds.size()) {
            if (spare == null) {
                spare = new OrdinalBucket(this.newEmptyBucket());
            }
            spare.hashAsLong(this.bucketOrds.get(i));
            spare.docCount = this.bucketDocCount(i);
            spare.bucketOrd = i++;
            spare = ordered.insertWithOverflow(spare);
        }
        InternalGeoGridBucket[] list = new InternalGeoGridBucket[ordered.size()];
        for (int i2 = ordered.size() - 1; i2 >= 0; --i2) {
            OrdinalBucket bucket = (OrdinalBucket)ordered.pop();
            bucket.aggregations = this.bucketAggregations(bucket.bucketOrd);
            list[i2] = bucket;
        }
        return this.buildAggregation(this.name, this.requiredSize, Arrays.asList(list), this.pipelineAggregators(), this.metaData());
    }

    @Override
    public InternalGeoGrid buildEmptyAggregation() {
        return this.buildAggregation(this.name, this.requiredSize, Collections.emptyList(), this.pipelineAggregators(), this.metaData());
    }

    @Override
    public void doClose() {
        Releasables.close(this.bucketOrds);
    }

    static class OrdinalBucket
    extends InternalGeoGridBucket {
        long bucketOrd;
        InternalGeoGridBucket sourceBucket;

        OrdinalBucket(InternalGeoGridBucket sourceBucket) {
            super(sourceBucket.hashAsLong, sourceBucket.docCount, sourceBucket.aggregations);
            this.sourceBucket = sourceBucket;
        }

        void hashAsLong(long hashAsLong) {
            this.hashAsLong = hashAsLong;
            this.sourceBucket.hashAsLong = hashAsLong;
        }

        InternalGeoGridBucket buildBucket(InternalGeoGridBucket bucket, long hashAsLong, long docCount, InternalAggregations aggregations) {
            OrdinalBucket ordBucket = new OrdinalBucket(bucket);
            ordBucket.hashAsLong = hashAsLong;
            ordBucket.docCount = docCount;
            ordBucket.aggregations = aggregations;
            if (bucket instanceof OrdinalBucket) {
                ordBucket.bucketOrd = ((OrdinalBucket)bucket).bucketOrd;
            }
            return ordBucket;
        }

        @Override
        public Object getKey() {
            return this.sourceBucket.getKey();
        }

        @Override
        public String getKeyAsString() {
            return this.sourceBucket.getKeyAsString();
        }
    }
}

