/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.script;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.ElasticsearchException;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.Strings;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.io.stream.StreamInput;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.io.stream.StreamOutput;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ToXContent;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentBuilder;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentFactory;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.rest.RestStatus;

public class ScriptException
extends ElasticsearchException {
    private final List<String> scriptStack;
    private final String script;
    private final String lang;

    public ScriptException(String message, Throwable cause, List<String> scriptStack, String script, String lang) {
        super(Objects.requireNonNull(message), Objects.requireNonNull(cause), new Object[0]);
        this.scriptStack = Collections.unmodifiableList(Objects.requireNonNull(scriptStack));
        this.script = Objects.requireNonNull(script);
        this.lang = Objects.requireNonNull(lang);
    }

    public ScriptException(StreamInput in) throws IOException {
        super(in);
        this.scriptStack = Arrays.asList(in.readStringArray());
        this.script = in.readString();
        this.lang = in.readString();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeStringArray(this.scriptStack.toArray(new String[0]));
        out.writeString(this.script);
        out.writeString(this.lang);
    }

    @Override
    protected void metadataToXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field("script_stack", this.scriptStack);
        builder.field("script", this.script);
        builder.field("lang", this.lang);
    }

    public List<String> getScriptStack() {
        return this.scriptStack;
    }

    public String getScript() {
        return this.script;
    }

    public String getLang() {
        return this.lang;
    }

    public String toJsonString() {
        try {
            XContentBuilder json = XContentFactory.jsonBuilder().prettyPrint();
            json.startObject();
            this.toXContent(json, ToXContent.EMPTY_PARAMS);
            json.endObject();
            return Strings.toString(json);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public RestStatus status() {
        return RestStatus.BAD_REQUEST;
    }
}

