/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.rest.action.admin.indices;

import java.io.IOException;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.admin.indices.upgrade.post.UpgradeRequest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.admin.indices.upgrade.post.UpgradeResponse;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.support.IndicesOptions;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.node.NodeClient;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.Strings;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.settings.Settings;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.rest.BaseRestHandler;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.rest.RestChannel;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.rest.RestController;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.rest.RestRequest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.rest.action.RestToXContentListener;

public class RestUpgradeAction
extends BaseRestHandler {
    public RestUpgradeAction(Settings settings, RestController controller) {
        super(settings);
        controller.registerHandler(RestRequest.Method.POST, "/_upgrade", this);
        controller.registerHandler(RestRequest.Method.POST, "/{index}/_upgrade", this);
    }

    @Override
    public String getName() {
        return "upgrade_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        UpgradeRequest upgradeReq = new UpgradeRequest(Strings.splitStringByCommaToArray(request.param("index")));
        upgradeReq.indicesOptions(IndicesOptions.fromRequest(request, upgradeReq.indicesOptions()));
        upgradeReq.upgradeOnlyAncientSegments(request.paramAsBoolean("only_ancient_segments", false));
        return channel -> client.admin().indices().upgrade(upgradeReq, new RestToXContentListener<UpgradeResponse>((RestChannel)channel));
    }
}

